% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree-mboost.R
\name{survival_time_mboost}
\alias{survival_time_mboost}
\title{A wrapper for mean survival times with \code{mboost} models}
\usage{
survival_time_mboost(object, new_data)
}
\arguments{
\item{object}{A model from \code{blackboost()}.}

\item{new_data}{Data for prediction}
}
\value{
A tibble.
}
\description{
A wrapper for mean survival times with \code{mboost} models
}
\examples{
library(mboost)
boosted_tree <- blackboost(Surv(time, status) ~ age + ph.ecog,
  data = lung[-14, ], family = CoxPH()
)
survival_time_mboost(boosted_tree, new_data = lung[1:3, ])
}
\keyword{internal}
