% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_metrics.R
\name{cfbd_metrics_ppa_players_season}
\alias{cfbd_metrics_ppa_players_season}
\title{\strong{Get player season averages for predicted points added (PPA)}}
\usage{
cfbd_metrics_ppa_players_season(
  year = NULL,
  team = NULL,
  conference = NULL,
  position = NULL,
  athlete_id = NULL,
  threshold = NULL,
  excl_garbage_time = FALSE
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - S&P+ information by conference\cr
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC\cr
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC\cr}

\item{position}{(\emph{string} optional): Position abbreviation of the player you are searching for.\cr
Position Group  - options include:\cr
\itemize{
\item Offense: QB, RB, FB, TE,  OL, G, OT, C, WR\cr
\item Defense: DB, CB, S, LB,  DE, DT, NT, DL\cr
\item Special Teams: K, P, LS, PK\cr
}}

\item{athlete_id}{(\emph{Integer} optional): Athlete ID filter for querying a single athlete\cr
Can be found using the \code{\link[=cfbd_player_info]{cfbd_player_info()}} function.}

\item{threshold}{(\emph{Integer} optional): Minimum threshold of plays.}

\item{excl_garbage_time}{(\emph{Logical} default FALSE): Select whether to exclude Garbage Time (TRUE or FALSE)}
}
\value{
\code{\link[=cfbd_metrics_ppa_players_season]{cfbd_metrics_ppa_players_season()}} - A data frame with 23 variables:
\describe{
\item{\code{season}: integer.}{Season.}
\item{\code{athlete_id}: character.}{Athlete referencing id.}
\item{\code{name}: character.}{Athlete name.}
\item{\code{position}: character.}{Athlete Position.}
\item{\code{team}: character.}{Team name.}
\item{\code{conference}: character.}{Team conference.}
\item{\code{countable_plays}: integer.}{Number of plays which can be counted.}
\item{\code{avg_PPA_all}: double.}{Average overall predicted points added (PPA).}
\item{\code{avg_PPA_pass}: double.}{Average passing predicted points added (PPA).}
\item{\code{avg_PPA_rush}: double.}{Average rushing predicted points added (PPA).}
\item{\code{avg_PPA_first_down}: double.}{Average 1st down predicted points added (PPA).}
\item{\code{avg_PPA_second_down}: double.}{Average 2nd down predicted points added (PPA).}
\item{\code{avg_PPA_third_down}: double.}{Average 3rd down predicted points added (PPA).}
\item{\code{avg_PPA_standard_downs}: double.}{Average standard down predicted points added (PPA).}
\item{\code{avg_PPA_passing_downs}: double.}{Average passing down predicted points added (PPA).}
\item{\code{total_PPA_all}: double.}{Total overall predicted points added (PPA).}
\item{\code{total_PPA_pass}: double.}{Total passing predicted points added (PPA).}
\item{\code{total_PPA_rush}: double.}{Total rushing predicted points added (PPA).}
\item{\code{total_PPA_first_down}: double.}{Total 1st down predicted points added (PPA).}
\item{\code{total_PPA_second_down}: double.}{Total 2nd down predicted points added (PPA).}
\item{\code{total_PPA_third_down}: double.}{Total 3rd down predicted points added (PPA).}
\item{\code{total_PPA_standard_downs}: double.}{Total standard down predicted points added (PPA).}
\item{\code{total_PPA_passing_downs}: double.}{Total passing down predicted points added (PPA).}
}
}
\description{
\strong{Get player season averages for predicted points added (PPA)}
}
\examples{
\donttest{
cfbd_metrics_ppa_players_season(year = 2019, team = "TCU")
}

}
\keyword{Averages}
\keyword{Players}
\keyword{Points}
\keyword{Predicted}
\keyword{Season}
