% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.fmca}
\alias{predict.fmca}
\title{Predict the principal components for new trajectories}
\usage{
\method{predict}{fmca}(
  object,
  newdata = NULL,
  nCores = max(1, ceiling(detectCores()/2)),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{output of \link{compute_optimal_encoding} function.}

\item{newdata}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs and \code{state}, associated state. All individuals must begin at the same time T0 and end at the same time Tmax (use \code{\link{cut_data}})..}

\item{nCores}{number of cores used for parallelization. Default is the half of cores.}

\item{verbose}{if TRUE print some information}

\item{...}{parameters for \code{\link{integrate}} function (see details).}
}
\value{
principal components for the individuals
}
\description{
Predict the principal components for new trajectories
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
Tmax <- 6
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(
  n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = Tmax,
  labels = c("A", "C", "G", "T")
)
d_JK2 <- cut_data(d_JK, Tmax)

# create basis object
m <- 6
b <- create.bspline.basis(c(0, Tmax), nbasis = m, norder = 4)
\donttest{
# compute encoding
encoding <- compute_optimal_encoding(d_JK2, b, computeCI = FALSE, nCores = 1)

# predict principal components
d_JK_predict <- generate_Markov(
  n = 5, K = K, P = PJK, lambda = lambda_PJK, Tmax = Tmax,
  labels = c("A", "C", "G", "T")
)
d_JK_predict2 <- cut_data(d_JK, Tmax)

pc <- predict(encoding, d_JK_predict2, nCores = 1)
}

}
\seealso{
\link{compute_optimal_encoding}
}
\author{
Quentin Grimonprez
}
