\name{conc}

\alias{conc}

\title{Specify a Concave Shape-Restriction in a CGAM Formula}

\description{A symbolic routine to define that the response is concave in a predictor in a formula argument to cgam}

\usage{conc(x)}

\arguments{
  \item{x}{A numeric predictor which has the same length as the response vector.}
}

\value{The vector x with a concave shape tag.}

\details{
  "conc" returns the vector "x" and imposes on it a shape attribute: "concave". According to the value of the vector itself and its shape attribute, the cone edges of the cone generated by the constraint matrix, which constrains the relationship between the response and "x" to be concave,  will be made. The cone edges are a set of basis employed in the hinge algorithm. 

  Note that "conc" does not make the corresponding cone edges itself. It sets things up to a subroutine called makedelta in cgam.

  See references cited in this section for more details.
}

\author{
  Mary C. Meyer and Xiyue Liao
}

\references{
  Meyer, M. C. (2013b) A simple new algorithm for quadratic programming with applications in statistics. \emph{Communications in Statistics \bold{42(5)}}, 1126--1139. 
}

\seealso{
  \code{\link{conv}}
}

\examples{
  # generate y
  x <- seq(-1, 2, by = 0.1)
  n <- length(x)
  y <- - x^2 + rnorm(n, .3)  

  # regress y on x under the shape-restriction: "concave"
  ans <- cgam(y ~ conc(x))

  # make a plot
  plot(x, y)
  lines(x, ans$muhat, col = 2)
  legend("topleft", bty = "n", "concave fit", col = 2, lty = 1)
}

\keyword{shape routine}
