% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_risk.R
\name{calc_risk}
\alias{calc_risk}
\title{Calculate the Cox risk associated with the covariates of the individual}
\usage{
calc_risk(data, coxphmod = NULL)
}
\arguments{
\item{data}{data frame containing the covariates to be used for risk-adjustment as named columns.}

\item{coxphmod}{(optional) a cox proportional hazards model generated using
\code{\link[survival:coxph]{coxph()}} or a list containing:
\itemize{
\item $formula (~ covariates),
\item $coefficients (named vector specifying risk adjustment coefficients
for covariates - names must be the same as in $formula and data colnames).
}}
}
\value{
A vector of nrow(data) specifying the increased risk of failure for each subject.
}
\description{
This function can be used to calculate the risk associated with the
covariates of an individual under a specified Cox PH model.
}
\details{
The subject specific increased risk is given by: \deqn{e^{\beta  Z_i}}{exp(\beta * Z_i)}
with \eqn{\beta}{\beta} the Cox coefficients and Z_i the covariates of subject i.
}
\examples{
crdat <- data.frame(age = rnorm(10, 40, 5), BMI = rnorm(10, 24, 3))
crlist <- list(formula = as.formula("~age + BMI"), coefficients = c("age"= 0.02, "BMI"= 0.009))
calc_risk(crdat, crlist)
}
\seealso{
Other utils: 
\code{\link{exp_hazards}},
\code{\link{gen_arriv_times}()},
\code{\link{gen_surv_times}()},
\code{\link{runlength}()}
}
\author{
Daniel Gomon
}
\concept{utils}
