% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numerics-provider.R
\docType{data}
\name{NumericsProvider}
\alias{NumericsProvider}
\title{NumericsProvider}
\arguments{
\item{n}{number of values}

\item{mean}{mean value}

\item{sd}{standard deviation}

\item{min}{minimum value}

\item{max}{maximum value}

\item{shape1, shape2}{non-negative parameters of the Beta distribution}

\item{ncp}{non-centrality parameter}
}
\description{
NumericsProvider
}
\details{
\strong{Methods}
  \describe{
    \item{\code{double()}}{
      get a double, pulls from normal distribution
    }
    \item{\code{integer()}}{
      get an integer, runs \code{\link{sample}} on range given
    }
    \item{\code{unif()}}{
      get numbers from the uniform distribution
    }
    \item{\code{norm()}}{
      get numbers from the normal distribution
    }
    \item{\code{lnorm()}}{
      get numbers from the lognormal distribution
    }
    \item{\code{beta()}}{
      get numbers from the beta distribution
    }
  }
}
\examples{
z <- NumericsProvider$new()

z$double()
z$double(10)
z$double(10, mean = 100)
z$double(10, mean = 100, sd = 17)

z$integer()
z$integer(10)
z$integer(10, 1, 20)
z$integer(10, 1, 10000000L)

z$unif()
z$norm()
z$lnorm(10)
z$beta(10, 1, 1)
}
\keyword{internal}
