% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{ch_generate}
\alias{ch_generate}
\title{Generate a fake dataset}
\usage{
ch_generate(..., n = 10, locale = NULL)
}
\arguments{
\item{...}{columns to include. must be in the allowed set. See
\strong{Allowed colun names} below. Three default columns are included
(name, job, phone_number) if nothing is specified - but are overridden
by any input.}

\item{n}{(integer) number of things to get, any non-negative integer}

\item{locale}{(character) the locale to use. options: only supported
for data types that have locale support, See each data provider for
details.}
}
\description{
Generate a fake dataset
}
\section{Allowed column names}{

\itemize{
\item name (default included)
\item job (default included)
\item phone_number (default included)
\item currency
\item color_name
\item rgb_color
\item rgb_css_color
}
}

\examples{
ch_generate()
ch_generate(n = 1)
ch_generate(n = 100)

ch_generate('job')
ch_generate('job', 'name')
ch_generate('job', 'color_name')

# locale
ch_generate(locale = "en_US")
ch_generate(locale = "fr_FR")
ch_generate(locale = "fr_CH")
}
