% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_df.R
\name{new_df}
\alias{new_df}
\alias{as_df}
\alias{fast_df}
\title{Fast data frame constructors}
\usage{
new_df(..., .nrows = NULL, .recycle = FALSE, .name_repair = FALSE)

as_df(x)

fast_df(...)
}
\arguments{
\item{...}{Key-value pairs.}

\item{.nrows}{\verb{[integer(1)]} - (Optional) number of rows. \cr
Commonly used to initialise a 0-column data frame with rows.}

\item{.recycle}{\verb{[logical(1)]} - Should arguments be recycled?
Default is \code{FALSE}.}

\item{.name_repair}{\verb{[logical(1)]} - Should duplicate names be made unique?
Default is \code{FALSE}.}

\item{x}{An object to coerce to a \code{data.frame}.}
}
\value{
A \code{data.frame}
}
\description{
Fast data frame constructors
}
\details{
\code{fast_df()} is a very fast bare-bones version of \code{new_df()} that
performs no checks and no recycling or name tidying.
All variables must be named and of equal length.
}
