% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_missing_tags.R
\name{find_missing_tags}
\alias{find_missing_tags}
\title{Find missing 'return' tag when function exported}
\usage{
find_missing_tags(
  package.dir = ".",
  roclets = NULL,
  load_code = NULL,
  clean = FALSE
)
}
\arguments{
\item{package.dir}{Location of package top level directory. Default is
working directory.}

\item{roclets}{Character vector of roclet names to use with package.
The default, \code{NULL}, uses the roxygen \code{roclets} option,
which defaults to \code{c("collate", "namespace", "rd")}.}

\item{load_code}{A function used to load all the R code in the package
directory. The default, \code{NULL}, uses the strategy defined by
the \code{load} roxygen option, which defaults to \code{\link[roxygen2:load_pkgload]{load_pkgload()}}.
See \link[roxygen2]{load} for more details.}

\item{clean}{If \code{TRUE}, roxygen will delete all files previously
created by roxygen before running each roclet.}
}
\value{
a list with the 3 data.frames with the missing tags
}
\description{
Find missing 'return' tag when function exported
}
\examples{
\dontrun{
# What you will do from inside your package
find_missing_tags()
}
# A reproducible example on a test package
pkg_path <- create_example_pkg()
find_missing_tags(pkg_path)
}
