% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/named.R
\name{check_named}
\alias{check_named}
\title{Check Named}
\usage{
check_named(x, nchar = c(0L, .Machine$integer.max), regex = ".*",
  unique = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{nchar}{A count or count range of the number of characters.}

\item{regex}{A string of the regular expression that must match all names.}

\item{unique}{A flag indicating whether the names must be unique.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks whether an object is named.
}
\examples{
check_named(2, error = FALSE)
x <- 1
names(x) <- "y"
check_named(x, error = FALSE)
}
\seealso{
\code{\link{check_unnamed}}, \code{\link{check_names}} and \code{\link{check_missing_names}}
}
