\name{ConcNoiseModel-class}
\alias{ConcNoiseModel}
\alias{ConcNoiseModel-class}
\alias{defaultParConcNoiseModel}
\alias{logf}
\alias{logf,ConcNoiseModel-method}
\title{Method logf.}
\usage{
  defaultParConcNoiseModel()

  ConcNoiseModel(...)
}
\arguments{
  \item{...}{parameters of constructor.}
}
\value{
  List of the default parameters.
}
\description{
  Method logf.

  Class \code{ConcNoiseModel} emulates perturbations in the
  analyte delivery system. The noise term is a normally
  distributed noise with zero-mean and diagonal covariance
  matrix. The diagonal structure of the covariance matrix
  underlines that the concentration noises of analytes do
  not affect each other.

  Get default constructor parameters of class
  \code{\link{ConcNoiseModel}}.

  Constructor method of ConcNoiseModel Class.

  Wrapper function ConcNoiseModel.
}
\details{
  Slots of the class: \tabular{rl}{ \code{gases} \tab Gas
  indices. \cr \code{ngases} \tab The number of gases. \cr
  \code{gnames} \tab Names of gases. \cr \code{concUnits}
  \tab Concentration units external to the model, values
  given in an input concentration matrix. \cr
  \code{concUnitsInt} \tab Concentration units internal for
  the model, values used to induce the noise. \cr
  \code{csd} \tab Parameter of standard deviation used to
  generate the noise. The deault value is 0.1. \cr
  \code{cntype} \tab Noise type (\code{logconc}). \cr
  \code{cnlogf} \tab Scaling factor for for log-terms if
  the noise type is \code{logconc}. The default value is
  \code{c(1, 1, 2)}. \cr }

  The logarithm term expresses an additional scaling of the
  amplitude applied to simulate more noise on high levels
  of concentration.

  Methods of the class: \tabular{rl}{ \code{predict} \tab
  Generates noise into the columns of an input
  concentration matrix. \cr \code{csd} \tab Gets the noise
  level. \cr \code{csd<-} \tab Sets the noise level. \cr }

  The \code{plot} method has one type (parameter \code{y}):
  \tabular{rl}{ \code{noise} \tab Depicts the noise vectors
  generated by the model. \cr }
}
\examples{
# model: default initialization
cn <- ConcNoiseModel()

# get information about the model
show(cn)
print(cn)

plot(cn)  

# model: custom parameters
# - many sensors
cn <- ConcNoiseModel(csd=0.5, gases=c(1, 3))

print(cn)

plot(cn)

# method plot
#  - plot types 'y': noise
cn <- ConcNoiseModel() # default model

plot(cn, "noise", main="plot(cn, 'noise')") 
# default plot type, i.e. 'plot(cn)' does the same plotting
}

