% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.model.fitting.R
\name{run.model.fitting}
\alias{run.model.fitting}
\title{run.model.fitting}
\usage{
run.model.fitting(interaction.data, distance.bins = NULL,
  distribution = "negative-binomial", bait.to.bait = FALSE,
  adjustment.terms = NULL, maxit = 100, epsilon = 1e-08, cores = 1,
  trace = FALSE, verbose = FALSE, interim.data.dir = NULL)
}
\arguments{
\item{interaction.data}{data.table object containing interaction counts. Must contain columns distance, count, and bait_trans_count.}

\item{distance.bins}{Number of bins to split distance into. Models are fit separately in each bin.}

\item{distribution}{Name of distribution of the counts. Options are 'negative-binomial', 
'poisson', 'truncated-poisson', and 'truncated-negative-binomial'}

\item{bait.to.bait}{Logical indicating if model should be fit as bait-to-bait}

\item{adjustment.terms}{Characted vector of extra terms to adjust for in the model fit}

\item{maxit}{Maximum number of IWLS iterations for fitting the model (passed to \code{glm.control})}

\item{epsilon}{Positive convergence tolerance for Poisson and negative binomial models. Passed to \code{glm.control}}

\item{cores}{Integer value specifying how many cores to use to fit model for cis-interactions.}

\item{trace}{Logical indicating if output should be produced for each of model fitting procedure. Passed to \code{glm.control} or \code{gamlss.control}}

\item{verbose}{Logical indicating whether to print progress reports.}

\item{interim.data.dir}{Path to directory to store intermediate QC data and plots.}
}
\value{
Interactions data with expeceted number of interactions and p-values added.
}
\description{
Run model fitting procedure for either bait-to-bait or other interactions.
Meant for internal use only.
}
