% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawFreq.R
\name{DrawFreq}
\alias{DrawFreq}
\title{Draw frequency vectors}
\usage{
DrawFreq(
  m,
  n,
  sigma,
  alpha = rep(1, length(sigma)),
  TypeDist = "AR",
  ncores = 1,
  parallel = FALSE
)
}
\arguments{
\item{m}{Number of frequency vectors.}

\item{n}{Length of frequency vector.}

\item{sigma}{Data variance, a scalar or a vector in the case of the Gaussian distribution mixture.}

\item{alpha}{Variance weights. By default all are equal to 1.}

\item{TypeDist}{Frequency distribution type. Possible values: "G" (Gaussian),
"FG" (Folded Gaussian radial) or "AR" (Adapted radius). Default is "AR".}

\item{ncores}{Number of cores. Multicore computation should be used only when the data is a mixture of Gaussian distributions.}

\item{parallel}{logical parameter that defines whether to perform the parallel computations. Default is FALSE.}
}
\value{
A matrix m x n, with frequency vectors in rows.
}
\description{
Function samples frequency vectors from the selected frequency distribution law.
}
\details{
The frequency vectors \eqn{w_1, \dots, w_m} are randomly sampled from
the predefined frequency distribution. The distribution law can be either
\eqn{N(0, \Sigma^{-1})} (\code{typeDist} = "G") or \eqn{p_R \cdot \varphi \cdot \Sigma^{-\frac{1}{2}}}
(\code{typeDist} = c("FG", "AR")), where \eqn{\varphi} is a vector
uniformly distributed on the unit sphere, \eqn{\Sigma} is a diagonal matrix with the data variance \code{sigma} on the diagonal
and where \eqn{p_R} is the radius density function.
For "FG" the radius distribution is \eqn{N(0,1)^+} and for "AR"
\eqn{p_R = C \cdot (R^2 + \frac{R^4}{4})^{0.5} \cdot \exp{(-0.5 \cdot R^2)}}, where C is a normalization constant.
}
\note{
The implemented method of the frequency sampling has been proposed in \insertRef{DBLP:journals/corr/KerivenBGP16}{chickn}.
}
\examples{
W1 = DrawFreq(m = 20, n = 10, sigma = 1e-3, TypeDist = "AR")
W2 = DrawFreq(m = 20, n = 10, sigma = 1e-3, TypeDist = "FG")
W3 = DrawFreq(m = 20, n = 10, sigma = 1e-3, TypeDist = "G")
}
\seealso{
\code{\link{EstimSigma}}, \code{\link{GenerateFrequencies}}, \code{\link{Sketch}}
}
