% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daylength.R
\name{daylength}
\alias{daylength}
\title{Compute sunrise and sunset times, and daylength}
\usage{
daylength(latitude, JDay, notimes.as.na = FALSE)
}
\arguments{
\item{latitude}{numeric value specifying the geographic latitude
(in decimal degrees) of the location of interest}

\item{JDay}{numeric (usually integer) value or vector specifying the
Julian day (day of the year), for which calculations should be done.}

\item{notimes.as.na}{parameter to determine whether for days without
sunrise or sunset, na should be returned for Sunset and Sunrise. If
left at FALSE (the default), the function returns -99 and 99 for
sunrise and sunset or polar nights and polar days, respectively.}
}
\value{
list with three elements Sunrise, Sunset and Daylength. For days
without sunrise (polar nights), sunset and sunrise become -99 and the
daylength 0. For days without sunset, sunset and sunrise are 99 and
daylength 24.
}
\description{
This function computes sunrise time, sunset time and daylength for a
particular location and day of the year (Julian day). This is done using
equations by Spencer (1971) and Almorox et al. (2005).
}
\examples{

daylength(latitude=50,JDay=40)
plot(daylength(latitude=35,JDay=1:365)$Daylength)


}
\references{
Spencer JW, 1971. Fourier series representation of the position of the Sun.
Search 2(5), 172.

Almorox J, Hontoria C and Benito M, 2005. Statistical validation of
daylength definitions for estimation of global solar radiation in Toledo,
Spain. Energy Conversion and Management 46(9-10), 1465-1471)
}
\author{
Eike Luedeling
}
\keyword{utility}
