% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_dtm.R
\name{output_dtm}
\alias{output_dtm}
\title{Convert or Write DTM/TDM Object Quickly}
\usage{
output_dtm(x, outputfile = NULL, doc_name = NULL)
}
\arguments{
\item{x}{an object created by \code{\link[tm]{TermDocumentMatrix}} 
or \code{\link[tm]{DocumentTermMatrix}}.}

\item{outputfile}{when it is NULL (default), no file is writen and a matrix is returned. 
When a filename is provided, it will write the matrix into a file. The filename must end 
with ".csv".}

\item{doc_name}{whether \code{NULL} or a character vector specifying the 
names you want to give to texts. If it is not a character vector, the function will try to coerce. 
Then the names become the row names of the returned matrix. 
Double inversed slashes will be converted to "/" by the function. The 
length of the argument must be equal to the number of files. \code{NA} element is not allowed.
By default it is \code{NULL}, which means no name is added.}
}
\description{
Given a TermDocumentMatrix or DocumentTermMatrix object, the function converts it 
to a matrix or write it into a .csv file, with additional filenames attached to it.
}
\examples{
require(tm)
x <- c(
  "Hello, what do you want to drink?", 
  "drink a bottle of milk", 
  "drink a cup of coffee", 
  "drink some water")
dtm <- corp_or_dtm(x, from = "v", type = "dtm")
output_dtm(dtm, doc_name = paste("doc", 1:4))
}
