% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-chr.R
\name{chk_chr}
\alias{chk_chr}
\alias{vld_chr}
\title{Check Character Scalar}
\usage{
chk_chr(x, x_name = NULL)

vld_chr(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if character scalar using

\code{is.character(x) && length(x) == 1L}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\section{Functions}{
\itemize{
\item \code{vld_chr}: Validate Character Scalar

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}}

\examples{
chk_chr("a")
try(chk_chr(1))
# vld_chr
vld_chr("")
vld_chr("a")
vld_chr(NA_character_)
vld_chr(c("a", "b"))
vld_chr(1)
}
\seealso{
Other deprecated: 
\code{\link{chk_dbl}()},
\code{\link{chk_deprecated}},
\code{\link{chk_wnum}()}
}
\concept{chk_character}
\concept{deprecated}
