% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-unique.R
\name{chk_unique}
\alias{chk_unique}
\alias{vld_unique}
\title{Check Unique}
\usage{
chk_unique(x, incomparables = FALSE, x_name = NULL)

vld_unique(x, incomparables = FALSE)
}
\arguments{
\item{x}{The object to check.}

\item{incomparables}{A vector of values that cannot be compared.
FALSE means that all values can be compared.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if unique using

\code{!anyDuplicated(x, incomparables = incomparables)}
}
\section{Functions}{
\itemize{
\item \code{vld_unique}: Validate Unique
}}

\examples{
# chk_unique
chk_unique(c(NA, 2))
try(chk_unique(c(NA, NA, 2)))
chk_unique(c(NA, NA, 2), incomparables = NA)
# vld_unique
vld_unique(NULL)
vld_unique(numeric(0))
vld_unique(c(NA, 2))
vld_unique(c(NA, NA, 2))
vld_unique(c(NA, NA, 2), incomparables = NA)
}
\seealso{
Other chk_misc: 
\code{\link{chk_length}()},
\code{\link{chk_match}()},
\code{\link{chk_named}()},
\code{\link{chk_not_any_na}()},
\code{\link{chk_not_empty}()},
\code{\link{chk_sorted}()},
\code{\link{chk_valid_name}()}
}
\concept{chk_misc}
