\name{cp.scree}
\alias{cp.scree}
\title{Scree plot for tradeoff designs}
\description{Line plot showing the relationship between the criterion used to assess column position
  balance and the number of iterations in the column position balancing routine.
}

\usage{
cp.scree(des)
}

\arguments{
  \item{des}{An \code{R} object containing the results from a call to \code{tradeoff.des}.}

}

\details{
  Column position balancing is the most computationally intensive process in calls to \code{tradeoff.des}. 
  The number of iterations required for this step is determined by the \code{Rc} argument in that function
  which defaults to the larger of 1,000 or 10 \code{x} the number of rows in the design. Large design problems 
  may require a larger number of iterations to achieve optimal column position balance. The plot generated by 
  this function can help to assess whether additional \code{Rc} iterations would lead to better column 
  position balance.
  
  See \code{tradeoff.des} for additional details.

} 

\value{
  A line plot showing the relationship between the criterion used to assess column position
  balance and the number of iterations in the column position balancing routine.
}

\examples{
des <- tradeoff.des(12, 4, 10, 9)
cp.scree(des)
}