% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{neighborhoodVoronoi}
\alias{neighborhoodVoronoi}
\title{Compute Voronoi neighborhoods.}
\usage{
neighborhoodVoronoi(pump.select = NULL, vestry = FALSE, statistic = NULL,
  polygon.vertices = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Default is NULL: all pumps are used. Otherwise, selection by a vector of numeric IDs: 1 to 13 for \code{pumps}; 1 to 14 for \code{pumps.vestry}.}

\item{vestry}{Logical. TRUE uses the 14 pumps from the Vestry Report. FALSE uses the 13 in the original map.}

\item{statistic}{NULL or Character. NULL, the default, makes no summary computation. "address" computes the number of addresses in each selected pump neighborhood. "fatality" computes the number of fatalities in pump neighborhoods.}

\item{polygon.vertices}{Logical. TRUE returns a list of x-y coordinates of the vertices of Voronoi cells. Useful for sp::point.in.polygon() as used in summary.voronoi() method.}
}
\value{
An R list with 12 objects.
\itemize{
  \item{\code{pump.id}: vector of selected pumps}
  \item{\code{voronoi}: output from deldir::deldir().}
  \item{\code{snow.colors}: neighborhood color based on snowColors().}
  \item{\code{x.rng}: range of x for plot.}
  \item{\code{y.rng}: range of y for plot.}
  \item{\code{select.string}: description of "pump.select" for plot title.}
  \item{\code{expected.data}:  expected neighborhood fatality counts, based on Voronoi cell area.}
  \item{\code{coordinates}: polygon vertices of Voronoi cells.}
  \item{\code{statistic.data}: observed neighborhood fatality counts.}
  \item{\code{pump.select}: "pump.select" from neighborhoodVoronoi().}
  \item{\code{statistic}: "statistic" from neighborhoodVoronoi().}
  \item{\code{vestry}: "vestry" from neighborhoodVoronoi().}
}
}
\description{
Data for Voronoi tessellation of John Snow's 1854 London cholera data.
}
\examples{
neighborhoodVoronoi()
neighborhoodVoronoi(vestry = TRUE)
neighborhoodVoronoi(pump.select = 6:7)
neighborhoodVoronoi(pump.select = -6)
neighborhoodVoronoi(pump.select = -6, polygon.vertices = TRUE)

# coordinates for vertices also available in returned object.
dat <- neighborhoodVoronoi(pump.select = -6)
dat$coordinates
}
\seealso{
\code{\link{addVoronoi}}, \code{\link{plot.voronoi}}, \code{\link{summary.voronoi}}, \code{vignette("pump.neighborhoods")}
}
