% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euclideanDistance.R
\name{euclideanDistance}
\alias{euclideanDistance}
\title{Compute the Euclidean distance between cases and/or pumps.}
\usage{
euclideanDistance(origin, destination = NULL, type = "case-pump",
  vestry = FALSE, unit = NULL)
}
\arguments{
\item{origin}{Numeric or Integer. Numeric ID of case or pump.}

\item{destination}{Numeric or Integer. Numeric ID(s) of case(s) or pump(s). Exclusion is possible via negative selection (e.g., -7). Default is NULL: this returns closest pump or "anchor" case.}

\item{type}{Character "case-pump", "cases" or "pumps".}

\item{vestry}{Logical. TRUE uses the 14 pumps from the Vestry Report. FALSE uses the 13 pumps from the original map.}

\item{unit}{Character. Unit of measurement: "meter" or "yard". Default is NULL, which returns the map's native scale. See \code{vignette("roads")} for information on unit distances.}
}
\value{
An R list.
}
\description{
Compute the Euclidean distance between cases and/or pumps.
}
\note{
The function uses a case's "address" or "anchor" case to compute distance.
}
\examples{
# path from case 1 to nearest pump.
euclideanDistance(1)

# path from case 1 to nearest pump in meters (approximate).
euclideanDistance(1, unit = "meter")

# path from case 1 to pump 6.
euclideanDistance(1, 6)

# exclude pump 7 from consideration.
euclideanDistance(1, -7)

# path from case 1 to case 6.
euclideanDistance(1, 6, type = "cases")

# path from pump 1 to pump 6.
euclideanDistance(1, 6, type = "pumps")

# Plot result
plot(euclideanDistance(1, unit = "meter"))
}
