% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pumpData.R
\name{pumpData}
\alias{pumpData}
\title{Compute pump coordinates.}
\usage{
pumpData(vestry = FALSE, orthogonal = FALSE, multi.core = FALSE)
}
\arguments{
\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry report. \code{FALSE} uses the 13 in the original map.}

\item{orthogonal}{Logical. \code{TRUE} returns pump "addresses": the coordinates of the orthogonal projection from a pump's location onto the network of roads. \code{FALSE} returns pump location coordinates.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. With Numeric, you specify the number logical cores (rounds with \code{as.integer()}). On Windows, only \code{multi.core = FALSE} is available.}
}
\value{
An R data frame.
}
\description{
Returns either the set of x-y coordinate for the pumps themselves or for their orthogonally projected "addresses" on the network of roads.
}
\note{
Note: The location of the fourteenth pump, at Hanover Square, and the "correct" location of the Broad Street pump are approximate.

The Dodson and Tobler coordinates of the original thirteen pumps, appended with name of nearest road, or the fourteen pumps included in the second version of Snow's map included in the Vestry report. This function documents the code that generates \code{\link{pumps}}, \code{\link{pumps.vestry}}, \code{\link{ortho.proj.pump}} and \code{\link{ortho.proj.pump.vestry}}.
}
\seealso{
\code{\link{pumpLocator}}
}
