% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unstack.R
\name{unstackFatalities}
\alias{unstackFatalities}
\title{Unstack "stacks" in Snow's cholera map.}
\usage{
unstackFatalities(multi.core = TRUE, compute = FALSE, dev.mode = FALSE)
}
\arguments{
\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. With Numeric, you specify the number logical cores. See \code{vignette("Parallelization")} for details.}

\item{compute}{Logical. \code{TRUE} computes data. \code{FALSE} uses pre-computed data.}

\item{dev.mode}{Logical. Development mode uses parallel::parLapply().}
}
\value{
An R list that includes \code{anchor.case}, \code{fatalities.address}, \code{fatalities.unstacked} and \code{ortho.proj}.
}
\description{
Unstacks fatalities data by 1) assigning the coordinates of the base case to all cases in a stack and 2) setting the base case as an "address" and making the number of fatalities an attribute.
}
\note{
This function is computationally intensive. This function documents the code that generates \code{\link{anchor.case}},  \code{\link{fatalities.address}}, \code{\link{fatalities.unstacked}} and \code{\link{ortho.proj}}.
}
\seealso{
\code{vignette("unstacking.fatalities")}
}
