% Generated by roxygen2 (4.0.2): do not edit by hand
\name{choroplethr_acs}
\alias{choroplethr_acs}
\title{Create a choropleth from ACS data.}
\usage{
choroplethr_acs(tableId, map, endyear = 2011, span = 5, buckets = 7,
  zoom = NULL)
}
\arguments{
\item{tableId}{The id of an ACS table}

\item{map}{A string indicating which map the data is for.  Must be "state", "county" or "zip".}

\item{endyear}{The end year of the survey to use.  See acs.fetch (?acs.fetch) and http://1.usa.gov/1geFSSj for details.}

\item{span}{The span of time to use.  See acs.fetch and http://1.usa.gov/1geFSSj for details.
on the same longitude and latitude map to scale. This variable is only checked when the "states" variable is equal to all 50 states.}

\item{buckets}{The number of equally sized buckets to places the values in.  A value of 1
will use a continuous scale, and a value in [2, 9] will use that many buckets.}

\item{zoom}{An optional list of states to zoom in on. Must come from the "name" column in
?state.regions.}
}
\value{
A choropleth.
}
\description{
Creates a choropleth using the US Census' American Community Survey (ACS) data.
Requires the acs package to be installed, and a Census API Key to be set with
the acs's api.key.install function.  Census API keys can be obtained at http://www.census.gov/developers/tos/key_request.html.
}
\examples{
\dontrun{
# population of all states, 9 equally sized buckets
choroplethr_acs("B01003", "state")

# median income, continuous scale, counties in New York, New Jersey and Connecticut
choroplethr_acs("B19301", "county", buckets=1, zoom=c("new york", "new jersey", "connecticut"))

# median income, all zip codes
choroplethr_acs("B19301", "zip") }
}
\references{
Uses the acs package created by Ezra Haber Glenn.
}
\seealso{
\code{api.key.install} in the acs package which sets an Census API key for the acs library

http://factfinder2.census.gov/faces/help/jsf/pages/metadata.xhtml?lang=en&type=survey&id=survey.en.ACS_ACS
which contains a list of all ACS surveys.
}
\keyword{acs}
\keyword{choropleth,}

