% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/admin1.R
\name{admin1_choropleth}
\alias{admin1_choropleth}
\title{Create an admin1-level choropleth for a specified country}
\usage{
admin1_choropleth(country.name, df, title = "", legend = "",
  num_colors = 7, zoom = NULL)
}
\arguments{
\item{country.name}{The name of the country. Must exactly match how the country is named in the "country"
column of ?admin1.regions in the choroplethrAdmin1 package.}

\item{df}{A data.frame with a column named "region" and a column named "value".  Elements in
the "region" column must exactly match how regions are named in the "region" column in ?admin1.regions
in the choroplethrAdmin1 package}

\item{title}{An optional title for the map.}

\item{legend}{An optional name for the legend.}

\item{num_colors}{The number of colors on the map. A value of 1
will use a continuous scale. A value in [2, 9] will use that many colors.}

\item{zoom}{An optional vector of regions to zoom in on. Elements of this vector must exactly
match the names of regions as they appear in the "region" column of ?admin1.regions.}
}
\description{
The map used comes from ?admin1.map in the choroplethrAdmin1 package. See ?get_admin_countries
and ?get_admin_regions in the choroplethrAdmin1 package for help with the spelling of regions.
}
\examples{
\dontrun{

data(df_japan_census)
head(df_japan_census)
# set the value we want to map to be the 2010 population estimates
df_japan_census$value=df_japan_census$pop_2010

# default map of all of japan
admin1_choropleth("japan",
                   df_japan_census,
                   "2010 Japan Population Estimates",
                   "Population")

# zoom in on the Kansai region and use a continuous scale
kansai = c("mie", "nara", "wakayama", "kyoto", "osaka", "hyogo", "shiga")
admin1_choropleth("japan",
                   df_japan_census,
                   "2010 Japan Population Estimates",
                   "Population",
                   1,
                   kansai)
}
}

