% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs.R
\name{county_choropleth_acs}
\alias{county_choropleth_acs}
\title{Create a US County choropleth from ACS data}
\usage{
county_choropleth_acs(tableId, endyear = 2011, span = 5, num_colors = 7,
  state_zoom = NULL, county_zoom = NULL)
}
\arguments{
\item{tableId}{The id of an ACS table}

\item{endyear}{The end year of the survey to use.  See acs.fetch (?acs.fetch) and http://1.usa.gov/1geFSSj for details.}

\item{span}{The span of time to use.  See acs.fetch and http://1.usa.gov/1geFSSj for details.}

\item{num_colors}{The number of colors on the map. A value of 1 
will use a continuous scale. A value in [2, 9] will use that many colors.}

\item{state_zoom}{An optional vector of states to zoom in on. Elements of this vector must exactly 
match the names of states as they appear in the "region" column of ?state.regions.}

\item{county_zoom}{An optional vector of counties to zoom in on. Elements of this vector must exactly 
match the names of counties as they appear in the "region" column of ?county.regions.}
}
\value{
A choropleth.
}
\description{
Creates a US County choropleth using the US Census' American Community Survey (ACS) data.  
Requires the acs package to be installed, and a Census API Key to be set with 
the acs's api.key.install function.  Census API keys can be obtained at http://www.census.gov/developers/tos/key_request.html.
}
\examples{
\dontrun{
# median income, all counties in US
county_choropleth_acs("B19301")

# continuous scale, zooing in on all counties in New York, New Jersey and Connecticut
county_choropleth_acs("B19301", num_colors=1, state_zoom=c("new york", "new jersey", "connecticut"))

# zooming in on the 5 counties (boroughs) that make up New York City
library(dplyr)
library(choroplethrMaps)
data(county.regions)

nyc_county_names=c("kings", "bronx", "new york", "queens", "richmond")
nyc_county_fips = county.regions \%>\%
  filter(state.name=="new york" & county.name \%in\% nyc_county_names) \%>\%
  select(region)
county_choropleth_acs("B19301", num_colors=1, county_zoom=nyc_county_fips$region)
}
}
\references{
Uses the acs package created by Ezra Haber Glenn.
}
\seealso{
\code{api.key.install} in the acs package which sets an Census API key for the acs library

http://factfinder2.census.gov/faces/help/jsf/pages/metadata.xhtml?lang=en&type=survey&id=survey.en.ACS_ACS 
which contains a list of all ACS surveys.
}
\keyword{acs}
\keyword{choropleth,}
