% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify.R
\name{simplify_chords}
\alias{simplify_chords}
\title{simplify_chords}
\usage{
simplify_chords(data)
}
\arguments{
\item{data}{character. The chords to be simplified.}
}
\value{
The dataset with a new column called "chord_simplified"
with the simplified version of the chords.
}
\description{
Simplifies music chords extracted with the chords package, eliminating
chords extensions, such as 4th, 5th, 6th, 7th, 9th, sus. It leaves
the chords in the simplest format possible.
}
\examples{
{
\donttest{
  songs <- get_songs("tim-maia")
  chords <- get_chords(songs$url[2])
  simplify_chords(chords)
}
}
}
