% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\title{Preprocess time/wavelength data}
\usage{
preprocess(
  X,
  dim1,
  dim2,
  remove.time.baseline = TRUE,
  spec.smooth = TRUE,
  maxI,
  parallel,
  interpolate_rows = TRUE,
  interpolate_cols = TRUE,
  mc.cores = 2,
  ...
)
}
\arguments{
\item{X}{A numerical data matrix, or list of data matrices. Missing values
are not allowed. If rownames or colnames attributes are used, they should be
numerical and signify time points and wavelengths, respectively.}

\item{dim1}{A new, usually shorter, set of time points (numerical). The
range of these should not be outside the range of the original time points,
otherwise the function stops with an error message.}

\item{dim2}{A new, usually shorter, set of wavelengths (numerical). The
range of these should not be outside the range of the original wavelengths,
otherwise the function stops with an error message.}

\item{remove.time.baseline}{Logical, indicating whether baseline correction
should be done in the time direction, according to
\code{\link[ptw:baseline.corr]{baseline.corr}}. Default is TRUE.}

\item{spec.smooth}{Logical, indicating whether smoothing should be done in
the spectral direction, according to
\code{\link[stats:smooth.spline]{smooth.spline}}. Default is TRUE.}

\item{maxI}{if given, the maximum intensity in the matrix is set to this
value.}

\item{parallel}{Logical, indicating whether to use parallel processing.
Defaults to TRUE (unless you're on Windows).}

\item{interpolate_rows}{Logical. Whether to interpolate along dim1. Defaults
to TRUE.}

\item{interpolate_cols}{Logical. Whether to interpolate along dim2. Defaults
to TRUE.}

\item{mc.cores}{How many cores to use for parallel processing. Defaults to 2.}

\item{\dots}{Further optional arguments to
\code{\link[ptw:baseline.corr]{baseline.corr}}.}
}
\value{
The function returns the preprocessed data matrix, with row names and
column names indicating the time points and wavelengths, respectively.
}
\description{
Standard pre-processing of response matrices, consisting of a time axis and
a spectral axis (e.g. HPLC-DAD/UV data). For smooth data, like UV-VIS data,
the size of the matrix can be reduced by interpolation. By default,
the data are baseline-corrected in the time direction
(\code{\link[ptw:baseline.corr]{baseline.corr}}) and smoothed in the
spectral dimension using cubic smoothing splines (\code{\link[stats:smooth.spline]{smooth.spline}}.
}
\note{
Adapted from
\href{https://github.com/rwehrens/alsace/blob/master/R/preprocess.R}{preprocess}
function in the alsace package by Ron Wehrens.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sa)
new.ts <- seq(10,18.66,by=.01) # choose time-points
new.lambdas <- seq(200, 318, by = 2) # choose wavelengths
Sa_pr <- preprocess(Sa[[1]], dim1 = new.ts, dim2 = new.lambdas)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Wehrens, R., Bloemberg, T.G., and Eilers P.H.C. 2015. Fast
parametric time warping of peak lists. \emph{Bioinformatics}
\bold{31}:3063-3065. \doi{10.1093/bioinformatics/btv299}.
\item Wehrens, R., Carvalho, E., Fraser, P.D. 2015. Metabolite profiling in
LC–DAD using multivariate curve resolution: the alsace package for R. \emph{
Metabolomics} \bold{11:1}:143-154. \doi{10.1007/s11306-014-0683-5}.
}
}
\author{
Ethan Bass
}
