% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_interface.R
\name{new_report}
\alias{new_report}
\title{Create the initial Rmarkdown header for a report}
\usage{
new_report(
  title = "New chronicle Report",
  author = "chronicle user",
  prettydoc = TRUE,
  prettydoc_theme = "leonids",
  highlight = "github",
  number_sections = FALSE,
  table_of_content = FALSE,
  table_of_content_depth = 1,
  fig_width = 11,
  fig_height = 5
)
}
\arguments{
\item{title}{Title of the report.}

\item{author}{Author of the report.}

\item{prettydoc}{Whether or not to use prettydoc formatting on the html report. Default is TRUE.}

\item{prettydoc_theme}{Name of the theme used on prettydoc. Default is leonids.}

\item{highlight}{Rmarkdown highlight theming. Default is github highlighting.}

\item{number_sections}{Whether or not to number the sections and subsections fo the report.}

\item{table_of_content}{Whether or not to include a table fo content at the beginning of the report.}

\item{table_of_content_depth}{The depth of sections and subsections to be displayed on the table of content.}

\item{fig_width}{Set the global figure width or the rmarkdown file.}

\item{fig_height}{Set the global figure height or the rmarkdown file.}
}
\value{
A string containing an R Markdown header
}
\description{
Create the initial Rmarkdown header for a report
}
\examples{
library(magrittr)
library(chronicle)
new_report(title = 'Simple Report Header',
           author = 'Anonymous Developer',
           prettydoc = FALSE)
new_report(title = 'Prettier Report Header',
           author = 'The same person as before',
           prettydoc = TRUE)
}
