% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XArray-xattrib.R, R/SpatialStack-base.R
\name{length,XArray-method}
\alias{length,XArray-method}
\alias{nlayers,XArray-method}
\alias{nlayers,SpatialStack-method}
\title{Number of elements or layers in a \code{\link{RasterArray}} or \code{\link{SpatialArray}} class object}
\usage{
\S4method{length}{XArray}(x)

\S4method{nlayers}{XArray}(x)

\S4method{nlayers}{SpatialStack}(x)
}
\arguments{
\item{x}{a \code{\link{RasterArray}} or \code{\link{SpatialArray}} class object.}
}
\value{
A \code{numeric} value.
}
\description{
Function to return the length of the array in which \code{RasterLayers} are organized.
}
\details{
The \code{length()} function returns the number elements that should be present based on the array structure itself, and not the total number of values stored in the object (such as the \code{length} method of \code{RasterStack}s). As the object can contain missing values, the number of actual layers can be queried with \code{\link{nlayers}}.
}
\examples{
data(dems)
# omit third element
dems[3] <- NA
# number of elements in the RasterArray
length(dems)
# remaining number values in the stack 
length(dems@stack)
# the number of remaining layers in the RasterArray
nlayers(dems)

}
