% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_xifti.R
\name{convert_to_dlabel}
\alias{convert_to_dlabel}
\alias{convert_to_dscalar}
\alias{convert_to_dtseries}
\alias{convert_xifti}
\title{Convert the intent of a CIFTI file or \code{"xifti"} object}
\usage{
convert_to_dlabel(
  x,
  cifti_target_fname = NULL,
  values = NULL,
  nsig = Inf,
  colors = "Set2",
  add_white = TRUE,
  return_conversion_table = FALSE
)

convert_to_dscalar(x, cifti_target_fname = NULL, names = NULL)

convert_to_dtseries(
  x,
  cifti_target_fname = NULL,
  time_start = 0,
  time_step = 1,
  time_unit = c("second", "hertz", "meter", "radian")
)

convert_xifti(
  x,
  to = c("dscalar", "dtseries", "dlabel"),
  cifti_target_fname = NULL,
  ...
)
}
\arguments{
\item{x}{The CIFTI file name or \code{"xifti"} object to convert.}

\item{cifti_target_fname}{File name for the converted CIFTI. Only used if
\code{x} is a CIFTI file name. If \code{NULL} (default), will use the same
name as \code{x} but with the extension updated.}

\item{values}{(Optional) A vector of the original data values. They should all
be unique. They may not all occur in the \code{"xifti"} data, but every
datapoint in the \code{"xifti"} must occur in \code{values}. Data will be
mapped to integers from $0$ to $N-1$, with $N$ being the length of
\code{values}.}

\item{nsig}{Take this many significant digits for the data values. If
\code{Inf} (default), do not round.}

\item{colors}{(Optional) "ROY_BIG_BL", the name of a ColorBrewer palette
(see \code{RColorBrewer::brewer.pal.info} and colorbrewer2.org), the name of
a viridisLite palette, or a character vector of colors. Default:
\code{"Set2"}.}

\item{add_white}{Append white to the beginning of the colors? Default: \code{TRUE}.}

\item{return_conversion_table}{Return the conversion table along with the
converted \code{"xifti"}? Default: \code{FALSE}}

\item{names}{The column names. If \code{NULL} (default), will be set to
"Column 1", "Column 2", ... .}

\item{time_start, time_step, time_unit}{(Optional) metadata for the new dtseries}

\item{to}{The desired intent: \code{"dscalar"} (default), \code{"dtseries"},
or \code{"dlabel"}}

\item{...}{Only used if \code{x} is a \code{"xifti"} object. Additional
options specific to the target type and intent, e.g. for
\code{convert_to_dlabel}.}

\item{xifti}{The \code{"xifti"}}
}
\value{
If \code{x} is a CIFTI, the target is a \code{"dlabel"} and
\code{return_conversion_table}, a length-2 list with the first entry being
the ".dlabel" \code{"xifti"} and the second being the conversion table.
Otherwise, the \code{"xifti"} or the output CIFTI file name is directly
returned.
}
\description{
Convert the intent of a CIFTI file or \code{"xifti"} object
}
\section{Functions}{
\itemize{
\item \code{convert_to_dlabel}: Give the ".dlabel" intent (code 3007/ConnDenseLabel) to an input
\code{"xifti"} object. Will use the same label table for each data column.

\item \code{convert_to_dscalar}: Give the ".dscalar" intent (code 3006/ConnDenseScalar) to an input
CIFTI file or \code{"xifti"} object.

\item \code{convert_to_dtseries}: Give the ".dtseries" intent (code 3002/ConnDenseSeries) to an input
\code{"xifti"} object.
}}

\keyword{internal}
