% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassPlotFunctions.R
\name{plot_predict.circGLM}
\alias{plot_predict.circGLM}
\title{Create a prediction plot from a circGLM object}
\usage{
plot_predict.circGLM(
  m,
  x,
  d,
  th,
  linkfun = function(x) m$r * atan(x),
  xlab = NA,
  ylab = expression(theta),
  colorPalette = c("#E69F00", "#56B4E9")
)
}
\arguments{
\item{m}{A \code{circGLM} object.}

\item{x}{Optional; Either a numeric vector with a continuous predictor or
string naming the desired variable to plot on the x-axis. If missing, we
just use the first continuous predictor in the \code{circGLM} object.}

\item{d}{Optional; Either a numeric vector with a categorical predictor or
string naming the desired variable to plot on the x-axis. If missing, we
just use the first categorical predictor in the \code{circGLM} object.}

\item{th}{Optional; Can be a new numeric vector containing outcome angles
corresponding to predictors \code{x} and potentially \code{d}.}

\item{linkfun}{The link function to be used. Should be the same as was used
for the creation of the \code{circGLM} object.}

\item{xlab}{A character string with the x-label.}

\item{ylab}{A character string with the y-label.}

\item{colorPalette}{The colors to use in plotting, max 2.}
}
\value{
A \code{\link[ggplot2]{ggplot}}, to which further \code{ggplot}
  elements can be added.
}
\description{
Plot the predictions made by a circGLM analysis.
}
\details{
Creates a ggplot showing a prediction plot showing linear predictor against
the circular outcome, with an optional grouping variable. One or more
regression lines show the predicted values for different values of the linear
and categorical predictors.

Predictors \code{x} and \code{d} and outcome \code{th} can be provided as
numeric vectors of the same length as the outcome in the \code{circGLM}
object \code{m}. This allows plotting the regression line from an earlier
dataset on a new dataset.

Alternatively, \code{x} and \code{d} can be strings containing names of
corresponding predictors in the original model. In that case, \code{th}
should not be provided.

The function makes an effort to find predictors to plot if none are given,
where it will simply take the first predictor in the dataset. If a plot
without grouping is required, \code{d} can be set to \code{NA}.
}
\examples{
dat <- generateCircGLMData()
m   <- circGLM(th ~ ., dat, Q = 100, burnin = 0)
plot(m, type = "predict")

}
\seealso{
\code{\link{plot_trace.circGLM}},
  \code{\link{plot_tracestack.circGLM}},
  \code{\link{plot_meancompare.circGLM}},
  \code{\link{plot_meanboxplot.circGLM}}, \code{\link{plot.circGLM}}.
}
