% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{publish_rmd}
\alias{publish_rmd}
\title{Publish an R Markdown file to Platform Reports}
\usage{
publish_rmd(rmd_file, report_id = NULL, report_name = NULL,
  provide_api_key = NULL, project_id = NULL, ...)
}
\arguments{
\item{rmd_file}{string, R Markdown file (.Rmd)}

\item{report_id}{integer, ID of an existing report, if provided, the
contents of the report will be replaced. If \code{report_id} is NULL, a new
report will be created.}

\item{report_name}{string, Title of report in platform}

\item{provide_api_key}{bool, Set to true to include API key in report.}

\item{project_id}{integer, Project_id that the report should be added to.}

\item{...}{additional parameters to send to \code{rmarkdown::render}. Note:
A temporary file will be used for \code{output_file} if \code{output_file}
is not explicitly set and \code{input} will be overwritten with
\code{rmd_file}.}
}
\description{
Publish an R Markdown file to Platform Reports
}
\details{
This function also supports passing \code{report_id}, \code{report_name},
\code{provide_api_key} and \code{project_id} as metadata in the report's
YAML front matter.  Just as the title of an RMarkdown document can be set
with \code{title: "my title!"}, these parameters can be set like
\preformatted{
  civis:
    report_name: "My Report Name"
    report_id: 9000
}
Since \code{report_id} is set, this code will overwrite the existing
report with that number, which may be useful when updating a report on
a schedule.  Any argument passed in explicitly to \code{publish_rmd}
will be used in place of the corresponding argument set in YAML metadata.
}
\note{
\code{rmarkdown::render} depends on a recent version of \code{pandoc}.
\code{pandoc} is distributed with RStudio and thus, \code{publish_rmd}
will work in an RStudio environment. Outside of RStudio \code{pandoc} may
be installed or \code{knitr::knit2html} can be used to convert an R
Markdown document into html. The html can then be published to Civis
with \code{publish_html}.
}
\examples{
\dontrun{

# Publish a standard report
publish_rmd("my_beautiful_doc.Rmd")

# Publish a parameterized R Markdown document
# See: http://rmarkdown.rstudio.com/developer_parameterized_reports.html
params <- list("region" = "east", start = as.Date("2015-02-01"))
publish_rmd("my_parameterized_doc.Rmd", params=params)
}
}
\seealso{
\code{\link{publish_html}} to publish html to Civis
}
