% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanTS.R
\name{cleanTS}
\alias{cleanTS}
\title{Clean univariate time-series data}
\usage{
cleanTS(
  data,
  date_format,
  imp_methods = c("na_interpolation", "na_locf", "na_ma", "na_kalman"),
  time = NULL,
  value = NULL,
  replace_outliers = TRUE
)
}
\arguments{
\item{data}{A data frame containing the input data. By default, it considers
that the first column to contain the timestamps and the second column
contains the observations.If that is not the case or if it contains more than
two columns then specify the names of time and value columns using the
\code{time} and \code{value} arguments.}

\item{date_format}{Format of timestamps used in the data. It uses lubridate
formats as mentioned
\href{https://lubridate.tidyverse.org/reference/parse_date_time.html#details}{here}.
More than one formats can be using a vectors of strings.}

\item{imp_methods}{The imputation methods to be used.}

\item{time}{Optional, the name of column in provided data to be used as
time column.}

\item{value}{Optional, the name of column in provided data, to be used as
value column.}

\item{replace_outliers}{Boolean, if \code{TRUE} then the outliers found will be
removed and imputed using the given imputation methods.}
}
\value{
A \code{cleanTS} object which contains:
\itemize{
\item Cleaned data
\item Missing timestamps
\item Duplicate timestamps
\item Imputation errors
\item Outliers
\item Outlier imputation errors
}
}
\description{
\code{cleanTS()}is the main function of the package which creates a cleanTS
object. It performs all the different data cleaning tasks, such as
converting the timestamps to proper format, imputation of missing values,
handling outliers, etc.
}
\examples{
# Convert sunspots.month to dataframe
data <- timetk::tk_tbl(sunspot.month)
print(data)

# Randomly insert missing values to simulate missing value imputation
set.seed(10)
ind <- sample(nrow(data), 100)
data$value[ind] <- NA

# Perform cleaning
cts <- cleanTS(data, date_format = "my", time = "index", value = "value")
print(cts)
}
