% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary_based_cleaning.R
\name{clean_using_dictionary}
\alias{clean_using_dictionary}
\title{Perform dictionary-based cleaning}
\usage{
clean_using_dictionary(data, dictionary)
}
\arguments{
\item{data}{The input \code{<data.frame>} or \code{<linelist>}}

\item{dictionary}{A \code{<data.frame>} with the dictionary associated with
the input data. This is expected to be compatible with the
\pkg{matchmaker} package and must contain the following four columns:
\describe{
\item{\code{options}}{This column contains the current values used to
represent the different groups in the input data frame (required).}
\item{\code{values}}{The values that will be used to replace the current
options (required).}
\item{\code{grp}}{The name of the columns where every option belongs to
(required).}
\item{\code{orders}}{This defines the user-defined order of different options
(optional).}
}}
}
\value{
A \code{<data.frame>} or \code{<linelist>} where the target options
have been replaced with their corresponding values in the columns
specified in the data dictionary.
}
\description{
Perform dictionary-based cleaning
}
\examples{
data <- readRDS(
  system.file("extdata", "messy_data.RDS", package = "cleanepi")
)
dictionary <- readRDS(
  system.file("extdata", "test_dict.RDS", package = "cleanepi")
)

# adding an option that is not defined in the dictionary to the 'gender'
# column
data$gender[2] <- "homme"
cleaned_df <- clean_using_dictionary(
  data = data,
  dictionary = dictionary
)
}
