% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{test_that_cli}
\alias{test_that_cli}
\title{Test cli output with testthat}
\usage{
test_that_cli(desc, code, configs = NULL)
}
\arguments{
\item{desc}{Test description, passed to \code{\link[testthat:test_that]{testthat::test_that()}}, after
appending the name of the cli configuration to it.}

\item{code}{Test code, it is modified to set up the cli config, and
then passed to \code{\link[testthat:test_that]{testthat::test_that()}}}

\item{configs}{cli configurations to test \code{code} with. The default is
\code{NULL}, which includes all possible configurations. It can also be a
character vector, to restrict the tests to some configurations only.
See available configurations below.}
}
\description{
Use this function in your testthat test files, to test cli output.
It requires testthat edition 3, and works best with snapshot tests.
}
\details{
\code{test_that_cli()} calls \code{\link[testthat:test_that]{testthat::test_that()}} multiple times, with
different cli configurations. This makes it simple to test cli output
with and without ANSI colors, with and without Unicode characters.

Currently available configurations:
\itemize{
\item \code{plain}: no ANSI colors, ASCII characters only.
\item \code{ansi}: ANSI colors, ASCII characters only.
\item \code{unicode}: no ANSI colors, Unicode characters.
\item \code{fancy}; ANSI colors, Unicode characters.
}

See examples below and in cli's own tests, e.g. in
https://github.com/cran/cli/blob/master/tests/testthat
and the corresponding snapshots at
https://github.com/cran/cli/tree/master/tests/testthat/_snaps
\subsection{Importtant note regarding Windows}{

Because of base R's limitation to record Unicode characters on Windows,
we suggest that you record your snapshots on Unix, or you restrict
your tests to ASCII configurations.

Unicode tests on Windows are automatically skipped by testthat
currently.
}
}
\examples{
# testthat cannot record or compare snapshots when you run these
# examples interactively, so you might want to copy them into a test
# file

# Default configurations
cli::test_that_cli("success", {
  testthat::local_edition(3)
  testthat::expect_snapshot({
    cli::cli_alert_success("wow")
  })
})

# Only use two configurations, because this output does not have colors
cli::test_that_cli(configs = c("plain", "unicode"), "cat_bullet", {
  testthat::local_edition(3)
  testthat::expect_snapshot({
    cli::cat_bullet(letters[1:5])
  })
})

# You often need to evaluate all cli calls of a test case in the same
# environment. Use `local()` to do that:
cli::test_that_cli("theming", {
  testthat::local_edition(3)
  testthat::expect_snapshot(local({
    cli::cli_div(theme = list(".alert" = list(before = "!!! ")))
    cli::cli_alert("wow")
  }))
})
}
