% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfData-plotMethods.R
\docType{methods}
\name{plot.cfDataList}
\alias{plot,cfDataList,missing-method}
\alias{plot,cfDataList,numeric-method}
\alias{plot,cfOther,missing-method}
\alias{plot.cfDataList}
\title{Default Clifro Plotting}
\usage{
\S4method{plot}{cfDataList,numeric}(x, y, ...)

\S4method{plot}{cfDataList,missing}(x, y, ...)

\S4method{plot}{cfOther,missing}(x, y)
}
\arguments{
\item{x}{a \code{cfData} or \code{cfDataList} object.}

\item{y}{missing for \code{cfData} objects, or a number representing the
dataframe to plot if \code{x} is a \code{cfDataList} object.}

\item{...}{arguments passed onto the different plotting methods.

These methods are intended to simplify the data visualisation and exploration
of CliFlo data. The type of plot is determined by the type of the data output
from a \pkg{clifro} query. All of these methods plot individual plots for
each CliFlo station (if there is more than one in the query). If \code{x} is
a \code{cfDataList}, by default the first datatype will be plotted unless
\code{y} is supplied.

The following table links the datatypes to the corresponding plot methods:

\tabular{ll}{
\strong{Datatype} \tab \strong{Method}\cr
Wind \tab \code{\link{plot.cfWind}} for windrose, wind speed and direction
contour plots\cr
Rain \tab \code{\link{plot.cfRain}} for plotting rainfall (mm) through time\cr
Screen Obs \tab \code{\link{plot.cfScreenObs}} for timeseries plots of air,
wet bulb, and dew-point temperature plots\cr
Max/Min Temp \tab \code{\link{plot.cfTemp}} for maximum, minimum and
average temperature timeseries plots\cr
Earth Temp \tab \code{\link{plot.cfEarthTemp}} for earth temperature
timeseries plots\cr
Sunshine \tab \code{\link{plot.cfSunshine}} for accumulated, hourly or daily
sunshine, timeseries plots\cr
Pressure \tab \code{\link{plot.cfPressure}} for mean sea level atmospheric
pressure timeseries plots\cr
Other data \tab No default plot methods\cr
}}
}
\description{
Plot \pkg{clifro} data based on the datatype.
}
\seealso{
\code{\link{cf_query}} to retrieve the CliFlo data and create
 \code{cfData} objects.

  Refer to \code{\link[ggplot2]{theme}} for more possible arguments to pass
  to these methods.
}

