% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/climdex.r
\name{climdex.cwd}
\alias{climdex.cwd}
\title{The \code{spells.can.span.years} option specifies whether spells can cross
year boundaries -- i.e., span years. The default for this is the same as for
fclimdex.}
\usage{
climdex.cwd(ci, spells.can.span.years = TRUE)
}
\arguments{
\item{ci}{Object of type climdexInput.}

\item{spells.can.span.years}{Whether to allow spells to span years}
}
\value{
A vector containing the length of the spell for each year.
}
\description{
The \code{spells.can.span.years} option specifies whether spells can cross
year boundaries -- i.e., span years. The default for this is the same as for
fclimdex.
}
\examples{
library(PCICt)

## Create a climdexInput object from some data already loaded in and
## ready to go.

## Parse the dates into PCICt.
tmax.dates <- as.PCICt(do.call(paste, ec.1018935.tmax[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
tmin.dates <- as.PCICt(do.call(paste, ec.1018935.tmin[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
prec.dates <- as.PCICt(do.call(paste, ec.1018935.prec[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")

## Load the data in.
ci <- climdexInput.raw(ec.1018935.tmax$MAX_TEMP,
ec.1018935.tmin$MIN_TEMP, ec.1018935.prec$ONE_DAY_PRECIPITATION,
tmax.dates, tmin.dates, prec.dates, base.range=c(1971, 2000))

## Create an annual timeseries of the CWD index.
cdd <- climdex.cdd(ci)
}
\references{
\url{http://etccdi.pacificclimate.org/list_27_indices.shtml}
}
\seealso{
\code{\link{climdexInput.raw}}, \code{\link{climdexInput.csv}},
\code{\link{spell.length.max}}.
}
\keyword{climate}
\keyword{ts}

