% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_covs_available.R
\name{check_covs_available}
\alias{check_covs_available}
\title{Returns parameters needed to calculate eGFR according to the method specified.}
\usage{
check_covs_available(
  cov_reqs = NULL,
  patient_covs = NULL,
  verbose = TRUE,
  fail = TRUE
)
}
\arguments{
\item{cov_reqs}{vector of covariates required for calculating derived covariatiate}

\item{patient_covs}{named list of covariates}

\item{verbose}{stop and describe missing covariate(s)?}

\item{fail}{invoke `stop()` if not all covariates available?}
}
\description{
returns true if all patient covs specified in required covs are non-null, non-NA and not a 0-character string. See `is.nil` for missing data types checked. Returns TRUE if no covariates are required.
}
\examples{
check_covs_available(
  egfr_cov_reqs('cockcroft_gault_ideal')[[1]],
  list(creat = 1, weight = 100, height = 160, sex = 'female', age = 90))
}
