% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ibw.R
\name{calc_ibw}
\alias{calc_ibw}
\title{Calculate ideal body weight for children and adults}
\usage{
calc_ibw(weight = NULL, height = NULL, age = NULL, sex = "male",
  method_children = "standard", method_adults = "devine", digits = NULL)
}
\arguments{
\item{weight}{weight in kg, can be vector}

\item{height}{height in cm, can be vector}

\item{age}{age in years, can be vector}

\item{sex}{either `male` or `female`, can be vector}

\item{method_children}{method to use for children >1 and <18 years. Choose from `standard`, `mclaren` (McLaren DS, Read WWC. Lancet. 1972;2:146-148.), `moore` (Moore DJ et al. Nutr Res. 1985;5:797-799), `bmi` (), `ada` (American Dietary Association)}

\item{method_adults}{method to use for >=18 years. Choose from `devine` (default, Devine BJ. Drug Intell Clin Pharm. 1974;8:650-655).}

\item{digits}{number of decimals (can be NULL to for no rounding)}
}
\description{
Get an estimate of ideal body weight. This function allows several commonly used equations
}
\details{
Equations:

<1yo Use actual body weight

1-17 years old ('standard'):
  if height < 5ft:
    IBW= (height in cm2 x 1.65)/1000
  if height > 5ft:
    IBW (male) = 39 + (2.27 x height in inches over 5 feet)
    IBW (female) = 42.2 + (2.27 x height in inches over 5 feet)

Methods not implemented yet:
  McLaren: IBW =
    - step1:   x = 50th percentile height for given age
    - step2: IBW = 50th percentile weight for x on weight-for-height scale
  Moore: IBW = weight at percentile x for given age, where x is percentile of height for given age
  BMI: IBW = 50th percentile of BMI for given age x (height in m)^2
  ADA: IBW = 50th percentile of WT for given age

>= 18 years old (Devine equation)
  IBW (male) = 50 + (2.3 x height in inches over 5 feet)
  IBW (female) = 45.5 + (2.3 x height in inches over 5 feet)
}
\examples{
calc_ibw(weight = 70, height = 170, age = 40, sex = "female")
calc_ibw(weight = 30, height = 140, age = 10, sex = "female")
}
