% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.fig.R
\docType{data}
\name{cdm.fig}
\alias{cdm.fig}
\alias{cols}
\title{Central data monitoring to assess deviations (cdm.fig)}
\format{
An object of class \code{character} of length 2.
}
\usage{
cdm.fig(df, cols, site, meta_title, seedno, output, nmin)
}
\arguments{
\item{df}{dateframe to be assessed for missing data}

\item{cols}{columns to be assessed}

\item{site}{column with sites}

\item{meta_title}{Y-axis lab, if empty then it is the column name}

\item{seedno}{the numeric site, if empty it is just \code{Sys.Date()}}

\item{output}{if 'fig' then the figure is the output, any other will output
the blinded site table}

\item{nmin}{minimum number of variables in site to be presented}
}
\value{
Returns a full markdown output.
}
\description{
\code{cdm.fig()} is a function to assess any deviations
}
\examples{
\dontrun{
   cdm.fig(df,cols="Mode of birth",
      site="maternal_trial_site")
   cdm.fig(df,cols="Gestational Age at birth",
      site="maternal_trial_site")
   library(knitr)
   kable(cdm.fig(df,cols="Mode of birth",
      site="maternal_trial_site",output = ""),row.names=F)
}

}
\keyword{datasets}
