% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{Date-setters}
\alias{Date-setters}
\alias{set_year.Date}
\alias{set_month.Date}
\alias{set_day.Date}
\title{Setters: date}
\usage{
\method{set_year}{Date}(x, value, ..., invalid = NULL)

\method{set_month}{Date}(x, value, ..., invalid = NULL)

\method{set_day}{Date}(x, value, ..., invalid = NULL)
}
\arguments{
\item{x}{\verb{[Date]}

A Date vector.}

\item{value}{\verb{[integer / "last"]}

The value to set the component to.

For \code{set_day()}, this can also be \code{"last"} to set the day to the
last day of the month.}

\item{...}{These dots are for future extensions and must be empty.}

\item{invalid}{\verb{[character(1) / NULL]}

One of the following invalid date resolution strategies:
\itemize{
\item \code{"previous"}: The previous valid instant in time.
\item \code{"previous-day"}: The previous valid day in time, keeping the time of
day.
\item \code{"next"}: The next valid instant in time.
\item \code{"next-day"}: The next valid day in time, keeping the time of day.
\item \code{"overflow"}: Overflow by the number of days that the input is invalid
by. Time of day is dropped.
\item \code{"overflow-day"}: Overflow by the number of days that the input is
invalid by. Time of day is kept.
\item \code{"NA"}: Replace invalid dates with \code{NA}.
\item \code{"error"}: Error on invalid dates.
}

Using either \code{"previous"} or \code{"next"} is generally recommended, as these
two strategies maintain the \emph{relative ordering} between elements of the
input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{invalid} must be supplied and
cannot be \code{NULL}. This is a convenient way to make production code robust
to invalid dates.}
}
\value{
\code{x} with the component set.
}
\description{
These are Date methods for the \link[=clock-setters]{setter generics}.
\itemize{
\item \code{set_year()} sets the year.
\item \code{set_month()} sets the month of the year. Valid values are in the range
of \verb{[1, 12]}.
\item \code{set_day()} sets the day of the month. Valid values are in the range
of \verb{[1, 31]}.
}
}
\examples{
x <- as.Date("2019-02-01")

# Set the day
set_day(x, 12:14)

# Set to the "last" day of the month
set_day(x, "last")

# You cannot set a Date to an invalid day like you can with
# a year-month-day. Instead, the default strategy is to error.
try(set_day(x, 31))
set_day(as_year_month_day(x), 31)

# You can resolve these issues while setting the day by specifying
# an invalid date resolution strategy with `invalid`
set_day(x, 31, invalid = "previous")
}
