/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.ompi;

import ch.ethz.ssh2.Connection;
import com.norbl.cbp.ppe.ConstantsEc2;
import com.norbl.cbp.ppe.ConstantsPPE;
import com.norbl.cbp.ppe.Ec2Wrangler;
import com.norbl.cbp.ppe.HyperthreadDisabler;
import com.norbl.cbp.ppe.NetworkInfo;
import com.norbl.cbp.ppe.NetworkSpec;
import com.norbl.cbp.ppe.NiM;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.cbp.ppe.ompi.ConstantsOmpi;
import com.norbl.util.ExceptionHandler;
import com.norbl.util.FileUtil;
import com.norbl.util.SshCp;
import com.norbl.util.ssh.ConstantsSSH;
import com.norbl.util.ssh.Ssh;
import com.norbl.util.ssh.SshExec;
import com.norbl.util.ssh.SshPingFailureException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OmpiConfig {
    State state;
    Ec2Wrangler ec2w;
    NetworkSpec spec;
    ParamsEc2 paramsEc2;

    public OmpiConfig(Ec2Wrangler ec2w, NetworkSpec spec, ParamsEc2 paramsEc2) {
        this.ec2w = ec2w;
        this.spec = spec;
        this.paramsEc2 = paramsEc2;
        this.state = State.nil;
    }

    private void setState(State state) {
        this.state = state;
        NiM.fireStateChangeEvent();
    }

    public boolean isPending() {
        return !State.isConfigured.equals((Object)this.state) && !State.notConfigured.equals((Object)this.state);
    }

    public boolean isConfigured() {
        return State.isConfigured.equals((Object)this.state);
    }

    public String getName() {
        return "open-mpi";
    }

    public String getStateDescription() {
        return this.state.getTitle();
    }

    public int getPort() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean config(String networkID) {
        NetworkInfo ni = NiM.getForID(networkID);
        HashMap<String, Connection> htc = null;
        try {
            this.setState(State.configuring);
            String master = this.ec2w.getMasterPublicDns(ni);
            List<String> slaves = this.ec2w.getSlavesPublicDns(ni);
            this.setState(State.pingingHosts);
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(master);
            hosts.addAll(slaves);
            this.state.appendToTitle(" n=" + Integer.toString(hosts.size()));
            this.waitForAllHostsToRespond(hosts);
            this.setState(State.connectingToInstances);
            htc = Ssh.connect(hosts, ConstantsEc2.EC2_USERNAME, this.paramsEc2.rsaKeyPairFile, 10000L, 600000L);
            this.setState(State.configuringIntraNetworkAccess);
            CmdExecutor sxMaster = new CmdExecutor(htc.get(master));
            SshCp scp = new SshCp();
            sxMaster.createRSAKeypair();
            String publicKeyFilename = ConstantsOmpi.PPE_MASTER_KEY_PAIR_FILENAME + ".pub";
            scp.cp(htc, slaves, master, ConstantsEc2.EC2_USER_SSH_DIR, publicKeyFilename);
            for (String slave : slaves) {
                SshExec sx = new SshExec(htc.get(slave));
                sx.exec("cd " + ConstantsEc2.EC2_USER_SSH_DIR + " ; " + "cat " + publicKeyFilename + " >> " + ConstantsOmpi.AUTHORIZED_KEYS_FILENAME);
            }
            this.setState(State.creatingHostfile);
            ArrayList<String> hostNames = new ArrayList<String>();
            hostNames.add(master);
            hostNames.addAll(slaves);
            File hostFile = this.createHostFile(hostNames);
            scp.cp(htc.get(master), ConstantsEc2.EC2_USER_HOME_DIR, hostFile);
            hostFile.delete();
            if (this.spec.disableHyperThreading) {
                this.setState(State.disablingHyperthreading);
                for (String host : hostNames) {
                    HyperthreadDisabler htd = new HyperthreadDisabler();
                    SshExec sx = new SshExec(htc.get(host));
                    htd.disable(sx, this.spec.slotsPerHost);
                }
            }
            this.setState(State.isConfigured);
            boolean bl = true;
            return bl;
        }
        catch (SshPingFailureException px) {
            this.setState(State.pingFailed);
            ExceptionHandler.text(px);
            boolean bl = false;
            return bl;
        }
        catch (Exception xxx) {
            this.setState(State.notConfigured);
            ExceptionHandler.text(xxx);
            boolean bl = false;
            return bl;
        }
        finally {
            if (htc != null) {
                Ssh.closeConnections(htc);
            }
        }
    }

    private void waitForAllHostsToRespond(List<String> hosts) throws SshPingFailureException {
        ArrayList<String> failures = new ArrayList<String>();
        for (String h : hosts) {
            try {
                Ssh.waitForPingSsh(h, ConstantsSSH.MAX_WAIT_FOR_SSH_PING);
            }
            catch (SshPingFailureException px) {
                failures.add(h);
            }
        }
        if (failures.size() > 0) {
            String s = new String();
            for (String h : failures) {
                s = s + h + " ";
            }
            throw new SshPingFailureException("Failed to contact hosts: " + s.trim());
        }
    }

    private File createHostFile(List<String> hostNames) throws IOException {
        StringBuilder s = new StringBuilder();
        s.append("# " + ConstantsOmpi.OMPI_HOSTFILE_NAME + "\n\n");
        for (String host : hostNames) {
            s.append(host + " slots=" + Integer.toString(this.spec.slotsPerHost) + "\n");
        }
        String txt = s.toString();
        File tmpDir = FileUtil.getTmpDir(ConstantsPPE.TMP_DIR);
        File hostfile = new File(tmpDir, ConstantsOmpi.OMPI_HOSTFILE_NAME);
        FileWriter fw = new FileWriter(hostfile);
        fw.write(txt);
        fw.flush();
        fw.close();
        return hostfile;
    }

    private File constructRemoteRSAKeyPairFile() {
        return new File("/home/" + ConstantsEc2.EC2_USERNAME + "/.ssh/" + ConstantsOmpi.PPE_MASTER_KEY_PAIR_FILENAME);
    }

    private File constructRemoteOmpiHistFile() {
        return new File("/home/" + ConstantsEc2.EC2_USERNAME + "/" + ConstantsOmpi.OMPI_HOSTFILE_NAME);
    }

    class CmdExecutor
    extends SshExec {
        CmdExecutor(Connection connection) throws IOException {
            super(connection);
        }

        public String createRSAKeypair() throws IOException {
            String dir = ConstantsEc2.EC2_USER_SSH_DIR;
            String fn = ConstantsOmpi.PPE_MASTER_KEY_PAIR_FILENAME;
            String cmd = "cd " + dir + "; " + "ssh-keygen -t rsa -f " + fn + " -P '';";
            return this.exec(cmd);
        }
    }

    public static enum State {
        nil("-"),
        configuring("configuring ompi"),
        connectingToInstances("connecting to instances"),
        pingingHosts("pinging hosts"),
        pingFailed("Ping failed"),
        configuringIntraNetworkAccess("configuring intra-network access"),
        creatingHostfile("creating hostfile"),
        disablingHyperthreading("disabling hyperthreading"),
        isConfigured("configured"),
        notConfigured("not configured");

        String title;

        private State(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public void appendToTitle(String a) {
            this.title = this.title + a;
        }
    }
}

