/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui.networkspec;

import com.norbl.cbp.ppe.Ec2InstanceType;
import com.norbl.cbp.ppe.gui.networkspec.Choice;
import com.norbl.cbp.ppe.gui.networkspec.RadioButtonCC;
import com.norbl.util.StringUtil;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class InstanceTypeChoice
extends Choice {
    Ec2InstanceType instanceType;

    public InstanceTypeChoice(Ec2InstanceType instanceType) {
        this.instanceType = instanceType;
    }

    @Override
    public String getChoiceType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Object getValue() {
        return this.instanceType.instanceType.toString();
    }

    @Override
    public String getLabel() {
        return this.instanceType.instanceType.toString();
    }

    @Override
    public void createCC() {
        this.cc = new RadioButtonCC(this.getLabel());
        this.cc.setEnabled(this.enabled);
        this.cc.setSelected(this.selected);
    }

    @Override
    public int getNColumns() {
        return 5;
    }

    @Override
    public String getColumnName(int iCol) {
        switch (iCol) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Cores";
            }
            case 2: {
                return "GB ram";
            }
            case 3: {
                return "Cluster";
            }
            case 4: {
                return "Price";
            }
        }
        return "";
    }

    @Override
    public Object getValue(int iCol) {
        switch (iCol) {
            case 0: {
                return this.getValue();
            }
            case 1: {
                return Integer.toString(this.instanceType.nCores);
            }
            case 2: {
                return StringUtil.f1(this.instanceType.ramGB);
            }
            case 3: {
                return this.booToString(this.instanceType.clusterSupport);
            }
            case 4: {
                return "$" + StringUtil.f2(this.instanceType.pricePiph);
            }
        }
        return "";
    }

    private String booToString(boolean b) {
        if (b) {
            return "yes";
        }
        return "no";
    }

    @Override
    public JComponent getComponent(int iCol) {
        JLabel x = new JLabel(this.getValue(iCol).toString());
        return x;
    }

    @Override
    public double getColumnWeight(int iCol) {
        switch (iCol) {
            case 0: {
                return 0.4;
            }
            case 1: {
                return 0.2;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.3;
            }
            case 4: {
                return 0.3;
            }
        }
        return 0.0;
    }

    @Override
    public int getGridBagAnchor(int iCol) {
        switch (iCol) {
            case 0: {
                return 512;
            }
            case 1: {
                return 768;
            }
            case 2: {
                return 768;
            }
            case 3: {
                return 768;
            }
            case 4: {
                return 768;
            }
        }
        return 0;
    }

    @Override
    public Insets getInsets(int iCol) {
        switch (iCol) {
            case 0: {
                return new Insets(0, 0, 0, 8);
            }
            case 1: {
                return new Insets(0, 0, 0, 12);
            }
            case 2: {
                return new Insets(0, 0, 0, 12);
            }
            case 3: {
                return new Insets(0, 0, 0, 12);
            }
            case 4: {
                return new Insets(0, 0, 0, 12);
            }
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public String getToolTip() {
        StringBuilder s = new StringBuilder("<html>\n");
        s.append(this.instanceType.description);
        s.append("\n</html>");
        return s.toString();
    }

    @Override
    public void setColumnHeaderToolTip(int iCol, JComponent c) {
        if (iCol == 4) {
            c.setToolTipText("Price per hour per instance");
        } else if (iCol == 3) {
            c.setToolTipText("Can be used launched in cluster placement groups.");
        }
    }

    private String toNS(Object x) {
        if (x != null) {
            return x.toString();
        }
        return " ";
    }
}

