/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui;

import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.gui.ActionCommandNetworkManager;
import com.norbl.cbp.ppe.gui.NetworkTablePopup;
import com.norbl.util.gui.GuiMetrics;
import com.norbl.util.gui.SwingDefaults;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class NetworkManagerFrame
extends JFrame
implements ActionListener {
    PPEManager manager;
    NetworkTablePopup networkTablePopup;
    private WevHandler wevh;
    private boolean disposeCalled;
    String title;
    private JMenuItem billingIDMI;
    private JMenuItem aboutMI;
    private JMenu aboutMenu;
    private JMenu accountMenu;
    private JMenuItem amiHelpMI;
    private JMenuItem authorizeInstanceBillingMI;
    private JMenuItem awsClientParams;
    private JMenuItem cancelAuthorizationMI;
    private JMenuItem createNetworkMI;
    private JMenu ebsVolumeMenu;
    private JMenuItem ec2ParamsMI;
    private JMenu editMenu;
    private JMenuItem exitMI;
    private JMenu exitMenu;
    private JMenu helpMenu;
    private JTabbedPane instanceTableTabPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenuBar jMenuBar1;
    private JMenuItem listEbsVolumesMI;
    private JPanel mainPan;
    private JMenuItem manualMI;
    private JScrollPane networkScrollPane;
    private JTable networkTable;
    private JMenu networksMenu;
    private JMenu showIDMenu;
    private JMenuItem updateEbsVolumesMI;
    private JMenuItem updateMI;
    private JMenu updateMenu;

    public NetworkManagerFrame(PPEManager manager, String title) {
        this.manager = manager;
        this.title = title;
        manager.setNetworkManagerFrame(this);
        this.wevh = new WevHandler();
        this.addWindowListener(this.wevh);
        this.disposeCalled = false;
    }

    public JTabbedPane getInstanceTableTabPane() {
        return this.instanceTableTabPane;
    }

    public void startGui() {
        this.setTitle(this.title);
        GuiMetrics.init();
        this.initComponents();
        this.setupMI(this.createNetworkMI, PPEManager.Op.createNetwork);
        this.setupMI(this.updateMI, PPEManager.Op.updateNetworkInfo);
        this.setupMI(this.listEbsVolumesMI, PPEManager.Op.listEbsVolumes);
        this.setupMI(this.updateEbsVolumesMI, PPEManager.Op.updateEbsVolumeList);
        this.setupMI(this.ec2ParamsMI, PPEManager.Op.editEc2Parameters);
        this.setupMI(this.awsClientParams, PPEManager.Op.editAwsClientParameters);
        this.setupMI(this.authorizeInstanceBillingMI, PPEManager.Op.authorizeInstanceBilling);
        this.setupMI(this.cancelAuthorizationMI, PPEManager.Op.cancelInstanceBilling);
        this.billingIDMI = new JMenuItem();
        this.setDisplayedBillingID(this.manager.getBillingIDForDisplay());
        this.showIDMenu.add(this.billingIDMI);
        this.setupMI(this.aboutMI, PPEManager.Op.showAbout);
        this.setupMI(this.exitMI, PPEManager.Op.exit);
        this.setupMI(this.amiHelpMI, PPEManager.Op.showAmiWebpage);
        this.setupMI(this.manualMI, PPEManager.Op.showManualWebpage);
        this.networkTable.setModel(this.manager.getNetworkTableModel());
        this.networkTable.setDefaultRenderer(JLabel.class, new XRenderer());
        this.networkTablePopup = new NetworkTablePopup(this.manager, this, this.networkTable);
        this.manager.instanceTableManager.setTabbedPane(this.instanceTableTabPane);
        SwingDefaults.setIcon(this);
        this.setVisible(true);
    }

    public void setDisplayedBillingID(String text) {
        this.billingIDMI.setText(text);
    }

    void setupMI(JMenuItem mi, PPEManager.Op op) {
        mi.addActionListener(this);
        mi.setActionCommand(new ActionCommandNetworkManager(op.toString(), null).toActionEventString());
        mi.setText(op.textMi);
    }

    public void disposeOfWindow() {
        if (!this.disposeCalled) {
            this.dispose();
            this.disposeCalled = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.manager.doOp(new ActionCommandNetworkManager(ev));
    }

    private void initComponents() {
        this.mainPan = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.networkScrollPane = new JScrollPane();
        this.networkTable = new JTable();
        this.instanceTableTabPane = new JTabbedPane();
        this.jMenuBar1 = new JMenuBar();
        this.networksMenu = new JMenu();
        this.createNetworkMI = new JMenuItem();
        this.updateMenu = new JMenu();
        this.updateMI = new JMenuItem();
        this.ebsVolumeMenu = new JMenu();
        this.listEbsVolumesMI = new JMenuItem();
        this.updateEbsVolumesMI = new JMenuItem();
        this.editMenu = new JMenu();
        this.ec2ParamsMI = new JMenuItem();
        this.awsClientParams = new JMenuItem();
        this.accountMenu = new JMenu();
        this.authorizeInstanceBillingMI = new JMenuItem();
        this.cancelAuthorizationMI = new JMenuItem();
        this.showIDMenu = new JMenu();
        this.helpMenu = new JMenu();
        this.amiHelpMI = new JMenuItem();
        this.manualMI = new JMenuItem();
        this.aboutMenu = new JMenu();
        this.aboutMI = new JMenuItem();
        this.exitMenu = new JMenu();
        this.exitMI = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.mainPan.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        this.jLabel1.setFont(new Font("Arial", 1, 22));
        this.jLabel1.setText("ec2 network manager");
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/com/norbl/cbp/ppe/gui/nbl_logo.jpg")));
        this.networkTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.networkTable.setCellSelectionEnabled(true);
        this.networkScrollPane.setViewportView(this.networkTable);
        GroupLayout mainPanLayout = new GroupLayout(this.mainPan);
        this.mainPan.setLayout(mainPanLayout);
        mainPanLayout.setHorizontalGroup(mainPanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 703, Short.MAX_VALUE).addComponent(this.jLabel2).addContainerGap()).addComponent(this.networkScrollPane, GroupLayout.Alignment.TRAILING, -1, 1046, Short.MAX_VALUE).addComponent(this.instanceTableTabPane, -1, 1046, Short.MAX_VALUE));
        mainPanLayout.setVerticalGroup(mainPanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanLayout.createSequentialGroup().addContainerGap().addGroup(mainPanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(38, 38, 38).addComponent(this.networkScrollPane, -2, 103, -2).addGap(18, 18, 18).addComponent(this.instanceTableTabPane, -1, 490, Short.MAX_VALUE)));
        this.networksMenu.setText("Networks");
        this.createNetworkMI.setText("Create network");
        this.networksMenu.add(this.createNetworkMI);
        this.jMenuBar1.add(this.networksMenu);
        this.updateMenu.setText("Update");
        this.updateMI.setText("Update");
        this.updateMenu.add(this.updateMI);
        this.jMenuBar1.add(this.updateMenu);
        this.ebsVolumeMenu.setText("Volumes");
        this.listEbsVolumesMI.setText("jMenuItem1");
        this.ebsVolumeMenu.add(this.listEbsVolumesMI);
        this.updateEbsVolumesMI.setText("jMenuItem1");
        this.ebsVolumeMenu.add(this.updateEbsVolumesMI);
        this.jMenuBar1.add(this.ebsVolumeMenu);
        this.editMenu.setText("Edit");
        this.ec2ParamsMI.setText("jMenuItem1");
        this.editMenu.add(this.ec2ParamsMI);
        this.awsClientParams.setText("jMenuItem2");
        this.editMenu.add(this.awsClientParams);
        this.jMenuBar1.add(this.editMenu);
        this.accountMenu.setText("Account");
        this.authorizeInstanceBillingMI.setText("jMenuItem1");
        this.accountMenu.add(this.authorizeInstanceBillingMI);
        this.cancelAuthorizationMI.setText("jMenuItem1");
        this.accountMenu.add(this.cancelAuthorizationMI);
        this.showIDMenu.setText("Show billing ID");
        this.accountMenu.add(this.showIDMenu);
        this.jMenuBar1.add(this.accountMenu);
        this.helpMenu.setText("Help");
        this.amiHelpMI.setText("jMenuItem1");
        this.helpMenu.add(this.amiHelpMI);
        this.manualMI.setText("jMenuItem1");
        this.helpMenu.add(this.manualMI);
        this.jMenuBar1.add(this.helpMenu);
        this.aboutMenu.setText("About");
        this.aboutMI.setText("About");
        this.aboutMenu.add(this.aboutMI);
        this.jMenuBar1.add(this.aboutMenu);
        this.exitMenu.setText("Exit");
        this.exitMI.setText("Exit");
        this.exitMenu.add(this.exitMI);
        this.jMenuBar1.add(Box.createHorizontalGlue());
        this.jMenuBar1.add(this.exitMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPan, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPan, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] args) {
        final NetworkManagerFrame f = new NetworkManagerFrame(null, "");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                f.startGui();
                f.setVisible(true);
            }
        });
    }

    class WevHandler
    extends WindowAdapter {
        WevHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (!NetworkManagerFrame.this.disposeCalled) {
                new Thread(){

                    @Override
                    public void run() {
                        NetworkManagerFrame.this.manager.exit();
                    }
                }.start();
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (!NetworkManagerFrame.this.disposeCalled) {
                new Thread(){

                    @Override
                    public void run() {
                        NetworkManagerFrame.this.manager.exit();
                    }
                }.start();
            }
        }
    }

    class XRenderer
    extends DefaultTableCellRenderer {
        XRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof JLabel) {
                return (JLabel)value;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static enum Cmd {
        createNetwork,
        update,
        exit;

    }
}

