% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q_rows.r
\name{Q_rows}
\alias{Q_rows}
\title{Queue function calls defined by rows in a data.frame}
\usage{
Q_rows(df, fun, const = list(), export = list(), seed = 128965,
  memory = NULL, template = list(), n_jobs = NULL, job_size = NULL,
  rettype = "list", fail_on_error = TRUE, workers = NULL,
  log_worker = FALSE, wait_time = NA, chunk_size = NA)
}
\arguments{
\item{df}{data.frame with iterated arguments}

\item{fun}{A function to call}

\item{const}{A list of constant arguments passed to each function call}

\item{export}{List of objects to be exported to the worker}

\item{seed}{A seed to set for each function call}

\item{memory}{Short for template=list(memory=value)}

\item{template}{A named list of values to fill in template}

\item{n_jobs}{The number of LSF jobs to submit; upper limit of jobs
if job_size is given as well}

\item{job_size}{The number of function calls per job}

\item{rettype}{Return type of function call (vector type or 'list')}

\item{fail_on_error}{If an error occurs on the workers, continue or fail?}

\item{workers}{Optional instance of QSys representing a worker pool}

\item{log_worker}{Write a log file for each worker}

\item{wait_time}{Time to wait between messages; set 0 for short calls
defaults to 1/sqrt(number_of_functon_calls)}

\item{chunk_size}{Number of function calls to chunk together
defaults to 100 chunks per worker or max. 10 kb per chunk}
}
\description{
Queue function calls defined by rows in a data.frame
}
