% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticTools.R
\name{x3pListPlot}
\alias{x3pListPlot}
\title{Plot a list of x3ps}
\usage{
x3pListPlot(
  x3pList,
  type = "faceted",
  legend.quantiles = c(0, 0.01, 0.25, 0.5, 0.75, 0.99, 1),
  height.quantiles = c(0, 0.01, 0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975, 0.99, 1),
  height.colors = rev(c("#7f3b08", "#b35806", "#e08214", "#fdb863", "#fee0b6", "#f7f7f7",
    "#d8daeb", "#b2abd2", "#8073ac", "#542788", "#2d004b")),
  na.value = "gray65"
)
}
\arguments{
\item{x3pList}{a list of x3p objects. If the x3p objects are named in the
list, then these names will be included in the title of their respective
plot}

\item{type}{dictates whether one plot faceted by surface matrix or a list of
plots per surface matrix is returned. The faceted plot will have a
consistent height scale across all surface matrices.}

\item{legend.quantiles}{vector of quantiles to be shown as tick marks on
legend plot}

\item{height.quantiles}{vector of quantiles associated with each color defined
in the height.colors argument}

\item{height.colors}{vector of colors to be passed to scale_fill_gradientn
that dictates the height value colorscale}

\item{na.value}{color to be used for NA values (passed to
scale_fill_gradientn)}
}
\value{
A ggplot object or list of ggplot objects showing the surface matrix
height values.
}
\description{
Plots the surface matrices in a list of x3p objects. Either
creates one plot faceted by surface matrix or creates individual plots per
surface matrix and returns them in a list.
}
\examples{
data(fadul1.1_processed,fadul1.2_processed)

x3pListPlot(list("Fadul 1-1" = fadul1.1_processed,
                 "Fadul 1-2" = fadul1.2_processed))
}
