% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{compute_diff_phase}
\alias{compute_diff_phase}
\title{Compute a Statistic for the Foreground Phase and the Background Phases}
\usage{
compute_diff_phase(scores.list, FUNC = mean, na.rm = TRUE, both = FALSE)
}
\arguments{
\item{scores.list}{a list of all phases}

\item{FUNC}{a function to be applied to both the foreground phase and the background phases}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds}

\item{both}{logical value. If \code{TRUE}, return the values of the \code{FUNC} for both the foreground phase and the background phases;
if \code{FALSE}, return their difference}
}
\value{
If \code{both = TRUE}, return the values of the statistic (calculated by \code{FUNC}) for both the foreground phase and the
background phases; if \code{both = FALSE}, return the difference
}
\description{
Compute a statistic (for example, a mean) based on all matching comparisons (foreground phase) and the same statistic
based on all non-matching comparisons (background phases)
}
\examples{
library(tidyverse)

data("bullets")

lands <- unique(bullets$bulletland)

comparisons <- data.frame(expand.grid(land1 = lands[1:6], land2 = lands[7:12]),
                          stringsAsFactors = FALSE)

comparisons <- comparisons \%>\%
  left_join(bullets \%>\% select(bulletland, sig1=sigs),
            by = c("land1" = "bulletland")) \%>\%
  left_join(bullets \%>\% select(bulletland, sig2=sigs),
            by = c("land2" = "bulletland"))

comparisons <- comparisons \%>\% mutate(
  cmps = purrr::map2(sig1, sig2, .f = function(x, y) {
    extract_feature_cmps(x$sig, y$sig, include = "full_result")
  })
)

comparisons <- comparisons \%>\%
  mutate(
    cmps_score = sapply(comparisons$cmps, function(x) x$CMPS.score),
    cmps_nseg = sapply(comparisons$cmps, function(x) x$nseg)
  )
  
cp1 <- comparisons \%>\% select(land1, land2, cmps_score, cmps_nseg)
cp1 <- cp1 \%>\% mutate(
  land1idx = land1 \%>\% str_sub(-1, -1) \%>\% as.numeric(),
  land2idx = land2 \%>\% str_sub(-1, -1) \%>\% as.numeric()
)

phases <- with(cp1, {
  get_all_phases(land1idx, land2idx, cmps_score, addNA = TRUE)
})

compute_diff_phase(phases)
}
