% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.htest.r
\docType{methods}
\name{as.htest}
\alias{as.htest}
\alias{as.htest,cocor-method}
\title{Convert to a list of class 'htest'}
\usage{
as.htest(result.object)

\S4method{as.htest}{cocor}(result.object)
}
\arguments{
\item{result.object}{A cocor result object of class 'cocor.indep.groups',
      'cocor.dep.groups.overlap', or 'cocor.dep.groups.nonoverlap'.}
}
\value{
Returns a list containing a list of class 'htest' for the result of each test with the following elements:
\item{data.name}{A character string giving the names of the data.}
\item{estimate}{The two correlations that have been compared and the related correlations.}
\item{method}{A character string indicating the performed test.}
\item{null.value}{The specified hypothesized value of the difference between the two correlations.}
\item{alternative}{A character string describing the alternative hypothesis.}
\item{parameter}{The degrees of freedom of the distribution of the test statistic.}
\item{statistic}{The value of the test statistic.}
\item{p.value}{The p-value of the test.}
\item{conf.int}{The confidence interval of the difference between the two correlations.}
}
\description{
Convert a cocor result object of class 'cocor.indep.groups', 'cocor.dep.groups.overlap',
      or 'cocor.dep.groups.nonoverlap' to a list of class 'htest'.
}
\examples{
data("aptitude")

cocor.result <- cocor(~knowledge + intelligence.a | logic + intelligence.a,
      aptitude$sample1)
as.htest(cocor.result)

}
\seealso{
\link{cocor}, \link{cocor.indep.groups}, \link{cocor.dep.groups.overlap},
      \link{cocor.dep.groups.nonoverlap}
}

