% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{eurostat_employment}
\alias{eurostat_employment}
\title{Employment distribution in EUROSTAT countries}
\format{
An object of class \code{data.frame} with 29 rows and 17 columns.
}
\usage{
eurostat_employment
}
\description{
According to the three–sector theory, as a country’s economy develops, employment
shifts from the primary sector (raw material extraction: farming, hunting, fishing,
mining) to the secondary sector (industry, energy and construction) and finally to
the tertiary sector (services). Thus, a country’s employment distribution can be
used as a predictor of economic wealth.

The `eurostat_employment` data set contains EUROSTAT data on employment
aggregated for both sexes, and all ages distributed by economic activity
(classification 1983-2008, NACE Rev. 1.1) in 2008 for the 29 EUROSTAT member
countries, thus reflecting reality just before the 2008 financial crisis.
Country codes in alphabetical order according to the country name in its
own language are: Belgium (BE), Cyprus (CY), Czechia (CZ), Denmark (DK),
Deutchland–Germany (DE), Eesti–Estonia (EE), Eire–Ireland (IE),
España–Spain (ES), France (FR), Hellas-Greece (GR), Hrvatska–Croatia (HR),
Iceland (IS), Italy (IT), Latvia (LV), Lithuania (LT), Luxembourg (LU),
Macedonia (MK), Magyarország-Hungary (HU), Malta (MT), Netherlands (NL),
Norway (NO), Österreich–Austria (AT), Portugal (PT), Romania (RO),
Slovakia (SK), Suomi–Finland (FI), Switzerland (CH), Turkey (TR),
United Kingdom (GB).

A key related variable is the logarithm of gross domestic product per person in
EUR at current prices (“logGDP”). For the purposes of exploratory data analyses
it has also been categorised as a binary variable indicating values higher or lower
than the median (“Binary GDP”). The employment composition (D = 11) is:

* Primary sector (agriculture, hunting, forestry, fishing, mining, quarrying)
* Manufacturing
* Energy (electricity, gas and water supply)
* Construction
* Trade repair transport (wholesale and retail trade, repair, transport,
storage, communications)
* Hotels restaurants
* Financial intermediation
* Real estate (real estate, renting and business activities)
* Educ admin defense soc sec (education, public administration, defence,
social security)
* Health social work
* Other services (other community, social and personal service activities)
}
\keyword{datasets}
