% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda4microbiome_longitudinal_functions.R
\name{coda_glmnet_longitudinal}
\alias{coda_glmnet_longitudinal}
\title{coda_glmnet_longitudinal}
\usage{
coda_glmnet_longitudinal(
  x,
  y,
  x_time,
  subject_id,
  ini_time,
  end_time,
  covar = NULL,
  lambda = "lambda.1se",
  nvar = NULL,
  alpha = 0.9,
  nfolds = 10,
  showPlots = TRUE
)
}
\arguments{
\item{x}{abundance table in long format (several rows per individual)}

\item{y}{outcome (binary)}

\item{x_time}{observation times}

\item{subject_id}{subject id}

\item{ini_time}{initial time to be analyzed}

\item{end_time}{end time to be analyzed}

\item{covar}{data frame with covariates (default = NULL)}

\item{lambda}{penalization parameter (default = "lambda.1se")}

\item{nvar}{number of variables to use in the glmnet.fit function (default = NULL)}

\item{alpha}{elastic net parameter (default = 0.9)}

\item{nfolds}{number of folds}

\item{showPlots}{if TRUE, shows the plots (default = FALSE)}
}
\value{
in case of binary outcome: list with "taxa.num","taxa.name","log-contrast coefficients","predictions","apparent AUC","mean cv-AUC","sd cv-AUC","predictions plot","signature plot","trajectories plot"
}
\description{
Microbial signatures in longitudinal studies.
Identification of a set of microbial taxa whose joint dynamics is associated with the phenotype of interest.
The algorithm performs variable selection through penalized regression over the summary of the log-ratio trajectories (AUC).
The result is expressed as the (weighted) balance between two groups of taxa.
}
\examples{

data(ecam_filtered, package = "coda4microbiome")   # load the data

ecam_results<-coda_glmnet_longitudinal (x=x_ecam[,(1:4)],y= metadata$diet,
x_time= metadata$day_of_life, subject_id = metadata$studyid, ini_time=0,
end_time=60,lambda="lambda.min",nfolds=4, showPlots=FALSE)

ecam_results$taxa.num

}
\author{
M. Calle - T. Susin
}
